<?

class Devices extends Devices_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function getTypesDropdown() {
		return array('' => 'All', 'gatewayclient' => 'Gateway Client', 'landevice' => 'Lan device');
	}
	
	function getSearchConditions () {
		$where = array();
		if ($this -> session -> userdata('search_device_mac')) {
			$where[] = 'd.mac LIKE "'.$this -> session -> userdata('search_device_mac').'%"';
		}
		if ($this -> session -> userdata('search_device_type')) {
			$where[] = 'd.type = "'.$this -> session -> userdata('search_device_type').'"';
		}
		if ($this -> session -> userdata('search_device_versionFrom')) {
			$where[] = 'd.version >= "'.$this -> session -> userdata('search_device_versionFrom').'"';
		}
		if ($this -> session -> userdata('search_device_versionTo')) {
			$where[] = 'd.version <= "'.$this -> session -> userdata('search_device_versionTo').'"';
		}
		if (!$this -> session -> userdata('search_device_deleted')) {
			$where[] = 'd.deleted = 0';
		}
		if (!$this -> session -> userdata('search_device_disconnected')) {
			$where[] = 'gcs.mac IS NOT NULL';
		}
		return $where;
	}

	function getConditionsStr($where) {
		$whereStr = implode(' AND ', $where);
		if ($whereStr)
			$whereStr = " WHERE $whereStr ";
		return $whereStr;
	}
	
	function get($where = null, $offset = null, $singleRow = false, $countOnly = false) {
		$query = 'SELECT gateway_client_id as device_id, mac as gc_mac, deleted as gc_deleted, "gatewayclient" as type, '.
						'mac, user_id, version, deleted, connected_date, disconnected_date, activation_date as added_date '.
					'FROM gatewayclient gc '.
					'UNION '.
					'SELECT landevice_id as device_id, gc.mac as gc_mac, gc.deleted as gc_deleted, "landevice" as type, '.
						'ld.mac, ld.user_id, ld.version, ld.deleted, connected_date, disconnected_date, added_date '.
					'FROM landevice ld '.
					'JOIN gatewayclient gc ON ld.gateway_client_id = gc.gateway_client_id';	
		$where = $where ? $this->getConditionsStr($where) : '';
		if ($countOnly) {
			$query = 'SELECT COUNT(*) as count '. 
				"FROM ($query) d ".
				'LEFT JOIN gatewayclientsession gcs ON (d.gc_mac = gcs.mac AND d.deleted = 0 AND d.gc_deleted = 0)'.$where;
			$result = $this->db->query($query)->row_array();
			$result = $result['count'];
		} else {
			$query = 'SELECT d.*, u.username, IF(gcs.mac IS NOT NULL,"'.STATUS_CONNECTED.'","'.STATUS_DISCONNECTED.'") as status '.
					"FROM ($query) d ".
					'JOIN user u ON d.user_id = u.id '.
					'LEFT JOIN gatewayclientsession gcs ON (d.gc_mac = gcs.mac AND d.deleted = 0 AND d.gc_deleted = 0)'.$where;
			if ($singleRow) {
				$result = $this->db->query($query)->row_array();
			} else {
				$limit = $offset !== null ? "LIMIT $offset, ".PER_PAGE : '';
				$query .= 'ORDER BY added_date DESC '.$limit;
				$result = $this->db->query($query)->result_array();
			}
		}
		return $result;
	}
}
