<?

class Devices_Model extends MY_Model
{
	
    function __construct()
    {
        parent::__construct();
    }
	
	function check($device_id, $deleted = null) {
		$device = null; 
		if ($device_id) {
			$device = $this->getById($device_id, $deleted);
			if (!$device) {
				$this->session->set_flashdata('error', 'Selected device not found.');
			}
		} else {
			$this->session->set_flashdata('error', 'No device selected.');
		}
		return $device;
	}
	
	function getURL($data) {
		$ok = false;
		$msg = '';
		$url = 'http://'.$data['user'].':'.$data['pass'].'@'.$data['ip_address'].':'.$data['port'].'/'.$data['queryString'];
		if ($response = $this->rest->getURL($data['mac'], $data['method'], $url, $data['body'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_OK) {
				$ok = true;
			} else {
				$msg = 'Get url failed. Reason: '.$this->errorMessages[$status];
			}
		}
		return $this->checkResult($ok, $msg) ? $response -> body -> body : null;
	}
	
	function executeScript($device, $data) {
		$ok = false;
		$msg = '';
		if ($response = $this->rest->executeScript($device['mac'], $data['script'])) {
			$status = $response -> body -> status;
			if ($status == STATUS_OK) {
				$ok = true;
			} else {
				$msg = 'Execute script failed. Reason: '.$this->errorMessages[$status];
			}
		}
		return $this->checkResult($ok, $msg) ? $response -> body -> body : null;
	}
}
