/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1GeneralizedTime;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1Type;
import codec.asn1.ASN1UTCTime;
import codec.asn1.Constraint;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import codec.x509.X509Extension;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;

public class CRLEntry
extends X509CRLEntry
implements ASN1Type,
Externalizable {
    private ASN1Sequence crlEntry_ = new ASN1Sequence();
    private ASN1Integer userCertificate_ = new ASN1Integer();
    private ASN1Choice revocationDate_;
    private ASN1SequenceOf crlEntryExtensions_;
    static /* synthetic */ Class class$codec$x509$X509Extension;

    public CRLEntry() {
        this.crlEntry_.add(this.userCertificate_);
        this.revocationDate_ = new ASN1Choice();
        this.revocationDate_.addType(new ASN1UTCTime());
        this.revocationDate_.addType(new ASN1GeneralizedTime());
        this.crlEntry_.add(this.revocationDate_);
        this.crlEntryExtensions_ = new ASN1SequenceOf(class$codec$x509$X509Extension == null ? (class$codec$x509$X509Extension = CRLEntry.class$("codec.x509.X509Extension")) : class$codec$x509$X509Extension);
        this.crlEntryExtensions_.setOptional(true);
        this.crlEntry_.add(this.crlEntryExtensions_);
    }

    public CRLEntry(BigInteger nr, Calendar wann) {
        this();
        this.setSerialNumber(nr);
        this.setRevocationDate(wann);
    }

    public void setConstraint(Constraint c) {
        this.crlEntry_.setConstraint(c);
    }

    public Constraint getConstraint() {
        return this.crlEntry_.getConstraint();
    }

    public void addExtension(X509Extension ex) {
        if (ex != null) {
            this.crlEntryExtensions_.add(ex);
            this.crlEntryExtensions_.setOptional(false);
        }
    }

    public void checkConstraints() throws ConstraintException {
        this.crlEntry_.checkConstraints();
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        this.crlEntry_.decode(dec);
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        this.crlEntry_.encode(enc);
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> res = new HashSet<String>();
        Iterator it = ((AbstractList)this.crlEntryExtensions_).iterator();
        while (it.hasNext()) {
            X509Extension theEx = (X509Extension)it.next();
            if (!theEx.isCritical()) continue;
            res.add(theEx.getOID().toString());
        }
        return res;
    }

    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.crlEntry_.encode(new DEREncoder(baos));
        }
        catch (Exception e) {
            throw new CRLException(e.getMessage());
        }
        return baos.toByteArray();
    }

    public Collection getExtensions() {
        return this.crlEntryExtensions_.getCollection();
    }

    public byte[] getExtensionValue(String oid) {
        byte[] res = null;
        Iterator it = ((AbstractList)this.crlEntryExtensions_).iterator();
        while (it.hasNext()) {
            X509Extension theEx = (X509Extension)it.next();
            if (!theEx.getOID().toString().equals(oid)) continue;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                theEx.encode(new DEREncoder(baos));
                res = baos.toByteArray();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return res;
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> res = new HashSet<String>();
        Iterator it = ((AbstractList)this.crlEntryExtensions_).iterator();
        while (it.hasNext()) {
            X509Extension theEx = (X509Extension)it.next();
            if (theEx.isCritical()) continue;
            res.add(theEx.getOID().toString());
        }
        return res;
    }

    public Date getRevocationDate() {
        ASN1Time a1t = (ASN1Time)this.revocationDate_.getInnerType();
        return a1t.getDate();
    }

    public BigInteger getSerialNumber() {
        return this.userCertificate_.getBigInteger();
    }

    public int getTag() {
        return this.crlEntry_.getTag();
    }

    public int getTagClass() {
        return this.crlEntry_.getTagClass();
    }

    public Object getValue() {
        return this.crlEntry_.getValue();
    }

    public boolean hasExtensions() {
        return !this.crlEntryExtensions_.isEmpty();
    }

    public boolean hasUnsupportedCriticalExtension() {
        boolean res = false;
        Set s = this.getCriticalExtensionOIDs();
        Iterator it = s.iterator();
        while (it.hasNext() && !res) {
            it.next();
        }
        return res;
    }

    public boolean isExplicit() {
        return this.crlEntry_.isExplicit();
    }

    public boolean isOptional() {
        return this.crlEntry_.isOptional();
    }

    public boolean isType(int eins, int zwei) {
        return this.crlEntry_.isType(eins, zwei);
    }

    public void setExplicit(boolean ex) {
        this.crlEntry_.setExplicit(ex);
    }

    public void setOptional(boolean opt) {
        this.crlEntry_.setOptional(opt);
    }

    public void setRevocationDate(Calendar cal) {
        ASN1Time inner = (ASN1Time)this.revocationDate_.getInnerType();
        if (inner == null) {
            inner = new ASN1UTCTime(cal);
            this.revocationDate_.setInnerType(inner);
        }
        inner.setDate(cal);
    }

    public void setRevocationDate(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(date);
        this.setRevocationDate(cal);
    }

    public void setSerialNumber(int nsnr) {
        this.setSerialNumber(new BigInteger(String.valueOf(nsnr), 10));
    }

    public void setSerialNumber(BigInteger nsnr) {
        try {
            this.userCertificate_.setBigInteger(nsnr);
        }
        catch (ASN1Exception aSN1Exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String offset) {
        String res = offset + "SNR (dec):" + this.getSerialNumber().toString(10);
        String date = DateFormat.getDateTimeInstance(0, 0).format(this.getRevocationDate());
        res = res + " date:" + date;
        if (!this.crlEntryExtensions_.isEmpty()) {
            res = res + "\n" + offset + "extensions (";
            res = res + this.crlEntryExtensions_.size() + "):";
            int i = 0;
            while (i < this.crlEntryExtensions_.size()) {
                res = res + "\n";
                res = res + ((X509Extension)this.crlEntryExtensions_.get(i)).toString(offset + " ");
                ++i;
            }
        }
        return res;
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
            s.write(res);
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void readExternal(ObjectInput s) throws IOException {
        try {
            this.decode(new DERDecoder((ObjectInputStream)s));
        }
        catch (ASN1Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

