/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.util.JCA;
import codec.x501.BadNameException;
import codec.x501.Name;
import codec.x509.AlgorithmIdentifier;
import codec.x509.SubjectPublicKeyInfo;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class RecipientInfo
extends ASN1Sequence {
    protected ASN1Integer version_;
    protected Name issuer_;
    protected ASN1Integer serial_;
    protected AlgorithmIdentifier cAlg_;
    protected ASN1OctetString ekey_;

    public RecipientInfo() {
        super(4);
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.issuer_ = new Name();
        this.serial_ = new ASN1Integer();
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        this.cAlg_ = new AlgorithmIdentifier();
        this.add(this.cAlg_);
        this.ekey_ = new ASN1OctetString();
        this.add(this.ekey_);
    }

    public RecipientInfo(X509Certificate cert, Key bek) throws BadNameException, GeneralSecurityException {
        super(4);
        if (cert == null || bek == null) {
            throw new NullPointerException("cert or bulk encryption key");
        }
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.issuer_ = new Name(cert.getIssuerDN().getName(), -1);
        this.serial_ = new ASN1Integer(cert.getSerialNumber());
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        PublicKey pub = cert.getPublicKey();
        SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(pub);
        AlgorithmIdentifier aid = pki.getAlgorithmIdentifier();
        Cipher cipher = Cipher.getInstance(pub.getAlgorithm());
        cipher.init(1, pub);
        this.cAlg_ = (AlgorithmIdentifier)aid.clone();
        this.add(this.cAlg_);
        byte[] b = bek.getEncoded();
        if (b == null || b.length == 0) {
            throw new InvalidKeyException("Key returns no or zero length encoding!");
        }
        if ((b = cipher.doFinal(b)) == null || b.length == 0) {
            throw new InvalidKeyException("Cipher returned no data!");
        }
        this.ekey_ = new ASN1OctetString(b);
        this.add(this.ekey_);
    }

    public RecipientInfo(X509Certificate cert, Key bek, int encType) throws BadNameException, GeneralSecurityException {
        super(4);
        if (cert == null || bek == null) {
            throw new NullPointerException("cert or bulk encryption key");
        }
        this.version_ = new ASN1Integer(0);
        this.add(this.version_);
        this.issuer_ = new Name(cert.getIssuerDN().getName(), encType);
        this.serial_ = new ASN1Integer(cert.getSerialNumber());
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        PublicKey pub = cert.getPublicKey();
        SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(pub);
        AlgorithmIdentifier aid = pki.getAlgorithmIdentifier();
        Cipher cipher = Cipher.getInstance(pub.getAlgorithm());
        cipher.init(1, pub);
        this.cAlg_ = (AlgorithmIdentifier)aid.clone();
        this.add(this.cAlg_);
        byte[] b = bek.getEncoded();
        if (b == null || b.length == 0) {
            throw new InvalidKeyException("Key returns no or zero length encoding!");
        }
        if ((b = cipher.doFinal(b)) == null || b.length == 0) {
            throw new InvalidKeyException("Cipher returned no data!");
        }
        this.ekey_ = new ASN1OctetString(b);
        this.add(this.ekey_);
    }

    public byte[] getEncryptedKey() {
        return (byte[])this.ekey_.getByteArray().clone();
    }

    public SecretKey getSecretKey(PrivateKey kdk, String bekalg) throws GeneralSecurityException {
        AlgorithmParameters params = this.cAlg_.getParameters();
        String alg = this.cAlg_.getAlgorithmOID().toString();
        Cipher cipher = Cipher.getInstance(alg);
        if (params == null) {
            cipher.init(2, kdk);
        } else {
            cipher.init(2, (Key)kdk, params);
        }
        byte[] b = this.ekey_.getByteArray();
        if (b.length == 0) {
            throw new InvalidKeyException("No encrypted key available!");
        }
        if ((b = cipher.doFinal(b)) == null || b.length == 0) {
            throw new InvalidKeyException("Cipher returned no data!");
        }
        return new SecretKeySpec(b, bekalg);
    }

    public Principal getIssuer() {
        return this.issuer_;
    }

    public BigInteger getSerialNumber() {
        return this.serial_.getBigInteger();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.cAlg_;
    }

    public String getAlgorithm() {
        String c = this.cAlg_.getAlgorithmOID().toString();
        String t = JCA.getName(c);
        if (t != null) {
            return t;
        }
        return c;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PKCS#7 RecipientInfo {\nVersion   : " + this.version_.toString() + "\n" + "Issuer    : " + this.issuer_.getName() + "\n" + "Serial    : " + this.serial_.toString() + "\n" + "Algorithm : " + this.getAlgorithm() + "\n" + "Enc. DEK  : " + this.ekey_.toString() + "\n}");
        return buf.toString();
    }
}

