/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OpenType;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.Decoder;
import codec.asn1.OIDRegistry;
import codec.pkcs.PKCSRegistry;
import java.io.IOException;

public class ContentInfo
extends ASN1Sequence {
    protected ASN1ObjectIdentifier contentType_;
    protected ASN1TaggedType content_;

    public ContentInfo() {
        this(PKCSRegistry.getDefaultRegistry());
    }

    public ContentInfo(OIDRegistry registry) {
        super(2);
        if (registry == null) {
            registry = PKCSRegistry.getDefaultRegistry();
        }
        this.contentType_ = new ASN1ObjectIdentifier();
        ASN1OpenType ot = new ASN1OpenType(registry, this.contentType_);
        this.content_ = new ASN1TaggedType(0, ot, true, true);
        this.add(this.contentType_);
        this.add(this.content_);
    }

    public ContentInfo(ASN1ObjectIdentifier o) {
        super(1);
        this.setContent(o);
    }

    public ContentInfo(ASN1RegisteredType o) {
        super(2);
        this.setContent(o);
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType_;
    }

    public ASN1Type getContent() {
        if (this.content_.isOptional()) {
            return null;
        }
        ASN1Type o = this.content_.getInnerType();
        if (o instanceof ASN1OpenType) {
            return null;
        }
        return o;
    }

    public void setContent(ASN1ObjectIdentifier oid) {
        this.clear();
        this.contentType_ = oid;
        this.content_ = null;
        this.add(this.contentType_);
    }

    public void setContent(ASN1RegisteredType type) {
        this.setContent(type.getOID(), type);
    }

    public void setContent(ASN1ObjectIdentifier oid, ASN1Type type) {
        this.clear();
        this.contentType_ = (ASN1ObjectIdentifier)oid.clone();
        this.content_ = new ASN1TaggedType(0, type, true);
        this.add(this.contentType_);
        this.add(this.content_);
    }

    public void decode(Decoder decoder) throws ASN1Exception, IOException {
        ASN1Type t;
        super.decode(decoder);
        if (!this.content_.isOptional() && (t = this.content_.getInnerType()) instanceof ASN1OpenType) {
            ASN1OpenType o = (ASN1OpenType)t;
            this.content_.setInnerType(o.getInnerType());
        }
    }
}

