/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import codec.asn1.OIDRegistry;
import codec.asn1.Resolver;
import codec.asn1.ResolverException;

public class DefinedByResolver
implements Resolver {
    private OIDRegistry registry_;
    private ASN1ObjectIdentifier oid_;

    public DefinedByResolver(OIDRegistry registry, ASN1ObjectIdentifier oid) {
        if (registry == null || oid == null) {
            throw new NullPointerException("Registry or OID is null!");
        }
        this.registry_ = registry;
        this.oid_ = oid;
    }

    public DefinedByResolver(ASN1ObjectIdentifier oid) {
        if (oid == null) {
            throw new NullPointerException("OID is null!");
        }
        this.registry_ = OIDRegistry.getGlobalOIDRegistry();
        this.oid_ = oid;
    }

    public ASN1Type resolve(ASN1Type caller) throws ResolverException {
        ASN1Type t = this.registry_.getASN1Type(this.oid_);
        if (t == null) {
            throw new ResolverException("Cannot resolve " + this.oid_);
        }
        return t;
    }
}

