/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;
import java.util.StringTokenizer;

public class ASN1ObjectIdentifier
extends ASN1AbstractType
implements Cloneable,
Comparable {
    private int[] value_ = new int[2];

    public ASN1ObjectIdentifier() {
    }

    public ASN1ObjectIdentifier(int[] oid) {
        this.set0(oid);
    }

    public ASN1ObjectIdentifier(String s) throws NumberFormatException {
        StringTokenizer tok;
        int[] oid = new int[16];
        if (s.startsWith("OID.") || s.startsWith("oid.")) {
            s = s.substring(4);
        }
        if ((tok = new StringTokenizer(s, ".")).countTokens() >= oid.length) {
            throw new IllegalArgumentException("OID has too many elements!");
        }
        int n = 0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            oid[n++] = Integer.parseInt(t);
        }
        int[] buf = new int[n];
        System.arraycopy(oid, 0, buf, 0, n);
        this.set0(buf);
    }

    public Object getValue() {
        return this.value_.clone();
    }

    public int[] getOID() {
        return (int[])this.value_.clone();
    }

    public void setOID(int[] oid) throws ConstraintException {
        this.set0(oid);
        this.checkConstraints();
    }

    private void set0(int[] oid) {
        if (oid == null) {
            throw new NullPointerException("Need an OID!");
        }
        int n = oid.length;
        if (n < 2) {
            throw new IllegalArgumentException("OID must have at least 2 elements!");
        }
        if (oid[0] < 0 || oid[0] > 2) {
            throw new IllegalArgumentException("OID[0] must be 0, 1, or 2!");
        }
        if (oid[1] < 0 || oid[1] > 39) {
            throw new IllegalArgumentException("OID[1] must be in the range 0,..,39!");
        }
        this.value_ = new int[n];
        System.arraycopy(oid, 0, this.value_, 0, n);
    }

    public int elementCount() {
        return this.value_.length;
    }

    public int getTag() {
        return 6;
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeObjectIdentifier(this);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        dec.readObjectIdentifier(this);
        this.checkConstraints();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.value_.length) {
            buf.append(this.value_[i] + ".");
            ++i;
        }
        if (this.value_.length > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)o;
        if (oid.value_.length != this.value_.length) {
            return false;
        }
        int i = 0;
        while (i < this.value_.length) {
            if (this.value_[i] != oid.value_[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = 23;
        int i = 0;
        while (i < this.value_.length) {
            h = h * 7 + this.value_[i];
            ++i;
        }
        return h;
    }

    public int compareTo(Object o) {
        int[] oid = ((ASN1ObjectIdentifier)o).value_;
        int n = Math.min(this.value_.length, oid.length);
        int i = 0;
        while (i < n) {
            if (this.value_[i] < oid[i]) {
                return -1;
            }
            if (this.value_[i] > oid[i]) {
                return 1;
            }
            ++i;
        }
        if (this.value_.length > n) {
            return 1;
        }
        if (oid.length > n) {
            return -1;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isPrefixOf(ASN1ObjectIdentifier o) {
        i = this.value_.length;
        if (o.value_.length >= i) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.value_[--i] == o.value_[i]) continue;
            return false;
lbl6:
            // 2 sources

            ** while (i > 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    public Object clone() {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier();
        int[] m = new int[this.value_.length];
        System.arraycopy(this.value_, 0, m, 0, m.length);
        oid.value_ = m;
        oid.setConstraint(this.getConstraint());
        return oid;
    }
}

