/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;

public class ASN1BitString
extends ASN1AbstractType {
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private static final byte[] MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] TRAIL_MASK = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128};
    private int pad_ = 0;
    private byte[] value_ = DEFAULT_VALUE;
    private boolean namedBits_ = false;

    public ASN1BitString() {
    }

    public ASN1BitString(boolean[] b) {
        this.setBits0(b);
    }

    public ASN1BitString(byte[] b, int pad) {
        this.setBits0(b, pad);
    }

    public Object getValue() {
        return this.getBits();
    }

    public boolean[] getBits() {
        if (this.value_.length == 0) {
            return new boolean[0];
        }
        boolean[] b = new boolean[this.value_.length * 8 - this.pad_];
        int n = 0;
        int i = 0;
        while (i < b.length) {
            b[i] = (this.value_[n] & MASK[i & 7]) != 0;
            if ((i & 7) == 7) {
                ++n;
            }
            ++i;
        }
        return b;
    }

    public void setBits(boolean[] bits) throws ConstraintException {
        this.setBits0(bits);
        this.checkConstraints();
    }

    protected void setBits0(boolean[] bits) {
        int j;
        this.namedBits_ = true;
        if (bits == null || bits.length == 0) {
            this.value_ = DEFAULT_VALUE;
            this.pad_ = 0;
            return;
        }
        int k = bits.length - 1;
        while (k >= 0) {
            if (bits[k]) break;
            --k;
        }
        if (k < 0) {
            this.value_ = DEFAULT_VALUE;
            this.pad_ = 0;
            return;
        }
        byte[] b = new byte[(++k + 7) / 8];
        byte m = 0;
        int n = 0;
        int i = 0;
        while (i < k) {
            j = i & 7;
            if (bits[i]) {
                m = (byte)(m | MASK[j]);
            }
            if (j == 7) {
                b[n++] = m;
                m = 0;
            }
            ++i;
        }
        j = i & 7;
        if (j != 0) {
            b[n] = m;
        }
        this.value_ = b;
        this.pad_ = 8 - j & 7;
    }

    public void setBits(byte[] b, int pad) throws ConstraintException {
        this.setBits0(b, pad);
        this.checkConstraints();
    }

    protected void setBits0(byte[] b, int p) {
        if (p < 0 || p > 7) {
            throw new IllegalArgumentException("Illegal pad value (" + p + ")");
        }
        this.namedBits_ = false;
        int n = b.length - 1;
        while (n >= 0) {
            if (b[n] != 0) break;
            --n;
        }
        if (n < 0) {
            if (p != 0) {
                throw new IllegalArgumentException("Zero length bit strings can't have pad bits!");
            }
            this.value_ = DEFAULT_VALUE;
            this.pad_ = 0;
            return;
        }
        if ((b[b.length - 1] & ~TRAIL_MASK[p]) != 0) {
            throw new IllegalArgumentException("trailing pad bits are not zero!");
        }
        this.value_ = b;
        this.pad_ = p;
    }

    public byte[] getBytes() {
        return this.value_;
    }

    public int getPadCount() {
        return this.pad_;
    }

    public int byteCount() {
        return this.value_.length;
    }

    public int bitCount() {
        return this.value_.length * 8 - this.pad_;
    }

    public boolean isNamedBits() {
        return this.namedBits_;
    }

    public boolean isZero() {
        return this.value_.length == 0;
    }

    public int getTag() {
        return 3;
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeBitString(this);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        boolean tmp = this.namedBits_;
        try {
            dec.readBitString(this);
            Object var4_3 = null;
            this.namedBits_ = tmp;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.namedBits_ = tmp;
            throw throwable;
        }
    }

    public String toString() {
        boolean[] bits = this.getBits();
        StringBuffer buf = new StringBuffer(12 + bits.length);
        buf.append("BitString '");
        int i = 0;
        while (i < bits.length) {
            if (bits[i]) {
                buf.append("1");
            } else {
                buf.append("0");
            }
            ++i;
        }
        buf.append("'");
        return buf.toString();
    }
}

