/*
 * Decompiled with CFR 0.152.
 */
package codec;

import codec.CorruptedCodeException;

public final class Base16 {
    private static final char[] BASE16_ = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZ").toCharArray();
    private static final byte F = -1;
    private static final byte[] REVERSE_ = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};

    private Base16() {
    }

    public static String encode(byte[] input) {
        if (input.length == 0) {
            return "";
        }
        StringBuffer output = new StringBuffer(2 * input.length);
        int i = 0;
        while (i < input.length) {
            byte a = input[i];
            int m = a >>> 4 & 0xF;
            output.append(BASE16_[m]);
            m = a & 0xF;
            output.append(BASE16_[m]);
            ++i;
        }
        return output.toString();
    }

    public static byte[] decode(String input) throws CorruptedCodeException {
        if (input.length() == 0) {
            return new byte[0];
        }
        int n = input.length();
        if (n % 2 == 1) {
            throw new CorruptedCodeException("uneven input length");
        }
        byte[] buf = new byte[n /= 2];
        int j = 0;
        n = 0;
        while (n < buf.length) {
            int a = input.charAt(j++) & 0xFF;
            a = REVERSE_[a];
            int b = input.charAt(j++) & 0xFF;
            b = REVERSE_[b];
            if (a == -1 || b == -1) {
                throw new CorruptedCodeException("illegal char");
            }
            buf[n] = (byte)(a << 4 | b);
            ++n;
        }
        return buf;
    }

    public static void main(String[] argv) {
        try {
            System.out.println(Base16.encode(Base16.decode("DEADcafe")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

