/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeJobFlowsRequestMarshaller
implements Marshaller<Request<DescribeJobFlowsRequest>, DescribeJobFlowsRequest> {
    @Override
    public Request<DescribeJobFlowsRequest> marshall(DescribeJobFlowsRequest describeJobFlowsRequest) {
        if (describeJobFlowsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeJobFlowsRequest> request = new DefaultRequest<DescribeJobFlowsRequest>(describeJobFlowsRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "DescribeJobFlows");
        request.addParameter("Version", "2009-03-31");
        if (describeJobFlowsRequest.getCreatedAfter() != null) {
            request.addParameter("CreatedAfter", StringUtils.fromDate(describeJobFlowsRequest.getCreatedAfter()));
        }
        if (describeJobFlowsRequest.getCreatedBefore() != null) {
            request.addParameter("CreatedBefore", StringUtils.fromDate(describeJobFlowsRequest.getCreatedBefore()));
        }
        List<String> jobFlowIdsList = describeJobFlowsRequest.getJobFlowIds();
        int jobFlowIdsListIndex = 1;
        for (String jobFlowIdsListValue : jobFlowIdsList) {
            if (jobFlowIdsListValue != null) {
                request.addParameter("JobFlowIds.member." + jobFlowIdsListIndex, StringUtils.fromString(jobFlowIdsListValue));
            }
            ++jobFlowIdsListIndex;
        }
        List<String> jobFlowStatesList = describeJobFlowsRequest.getJobFlowStates();
        int jobFlowStatesListIndex = 1;
        for (String jobFlowStatesListValue : jobFlowStatesList) {
            if (jobFlowStatesListValue != null) {
                request.addParameter("JobFlowStates.member." + jobFlowStatesListIndex, StringUtils.fromString(jobFlowStatesListValue));
            }
            ++jobFlowStatesListIndex;
        }
        return request;
    }
}

