/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignPrivateIpAddressesRequest
extends AmazonWebServiceRequest {
    private String networkInterfaceId;
    private List<String> privateIpAddresses;
    private Integer secondaryPrivateIpAddressCount;
    private Boolean allowReassignment;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public AssignPrivateIpAddressesRequest withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public List<String> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ArrayList<String>();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ArrayList<String> privateIpAddressesCopy = new ArrayList<String>(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public AssignPrivateIpAddressesRequest withPrivateIpAddresses(String ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<String>(privateIpAddresses.length));
        }
        for (String value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public AssignPrivateIpAddressesRequest withPrivateIpAddresses(Collection<String> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ArrayList<String> privateIpAddressesCopy = new ArrayList<String>(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public AssignPrivateIpAddressesRequest withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        return this;
    }

    public Boolean isAllowReassignment() {
        return this.allowReassignment;
    }

    public void setAllowReassignment(Boolean allowReassignment) {
        this.allowReassignment = allowReassignment;
    }

    public AssignPrivateIpAddressesRequest withAllowReassignment(Boolean allowReassignment) {
        this.allowReassignment = allowReassignment;
        return this;
    }

    public Boolean getAllowReassignment() {
        return this.allowReassignment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: " + this.getNetworkInterfaceId() + ", ");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: " + this.getPrivateIpAddresses() + ", ");
        }
        if (this.getSecondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: " + this.getSecondaryPrivateIpAddressCount() + ", ");
        }
        if (this.isAllowReassignment() != null) {
            sb.append("AllowReassignment: " + this.isAllowReassignment() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : ((Object)this.getPrivateIpAddresses()).hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.isAllowReassignment() == null ? 0 : this.isAllowReassignment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !((Object)other.getPrivateIpAddresses()).equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() != null && !other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.isAllowReassignment() == null ^ this.isAllowReassignment() == null) {
            return false;
        }
        return other.isAllowReassignment() == null || other.isAllowReassignment().equals(this.isAllowReassignment());
    }
}

