/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ReconnectPolicy;

public final class ReconnectPolicies {

    public static class EveryHalfHour
    implements ReconnectPolicy {
        private static final long PERIOD = 1800000L;
        private long lastRunning = 0L;

        public boolean shouldReconnect() {
            return System.currentTimeMillis() - this.lastRunning > 1800000L;
        }

        public void reconnected() {
            this.lastRunning = System.currentTimeMillis();
        }

        public EveryHalfHour copy() {
            return new EveryHalfHour();
        }
    }

    public static class Always
    implements ReconnectPolicy {
        public boolean shouldReconnect() {
            return true;
        }

        public void reconnected() {
        }

        public Always copy() {
            return this;
        }
    }

    public static class Never
    implements ReconnectPolicy {
        public boolean shouldReconnect() {
            return false;
        }

        public void reconnected() {
        }

        public Never copy() {
            return this;
        }
    }
}

