/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rijndael;

import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.util.ByteUtils;

public class RijndaelParameterSpec
implements AlgorithmParameterSpec {
    public static final int DEFAULT_BLOCK_SIZE = 128;
    private int blockSize;
    private byte[] iv;

    public RijndaelParameterSpec() {
        this(128);
    }

    public RijndaelParameterSpec(ModeParameterSpec modeParams) {
        this(128, modeParams);
    }

    public RijndaelParameterSpec(int blockSize) {
        this.blockSize = blockSize != 128 && blockSize != 192 && blockSize != 256 ? 128 : blockSize;
    }

    public RijndaelParameterSpec(int blockSize, ModeParameterSpec modeParams) {
        this(blockSize);
        this.iv = modeParams.getIV();
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public byte[] getIV() {
        return ByteUtils.clone(this.iv);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RijndaelParameterSpec)) {
            return false;
        }
        RijndaelParameterSpec otherSpec = (RijndaelParameterSpec)other;
        return this.blockSize == otherSpec.blockSize && ByteUtils.equals(this.iv, otherSpec.iv);
    }

    public int hashCode() {
        if (this.iv == null) {
            return this.blockSize;
        }
        return this.blockSize + this.iv.hashCode();
    }
}

