/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.pbe.PBES2ParameterSpec;
import de.flexiprovider.pki.AlgorithmIdentifier;
import java.io.IOException;
import java.util.ArrayList;

public class PBES2Parameters
extends AlgorithmParameters {
    private AlgorithmIdentifier keyDerivationFunction;
    private AlgorithmIdentifier encryptionScheme;
    static /* synthetic */ Class class$de$flexiprovider$core$pbe$PBES2ParameterSpec;

    public void init(AlgorithmParameterSpec params) throws InvalidParameterSpecException {
        if (!(params instanceof PBES2ParameterSpec)) {
            throw new InvalidParameterSpecException("parameters not supported");
        }
        PBES2ParameterSpec pbe2ParamSpec = (PBES2ParameterSpec)params;
        this.keyDerivationFunction = pbe2ParamSpec.getKeyDerivationFunction();
        this.encryptionScheme = pbe2ParamSpec.getEncryptionScheme();
    }

    public void init(byte[] encParams) throws IOException {
        try {
            PBES2ASN1Params asn1pbe2Params = new PBES2ASN1Params();
            ASN1Tools.derDecode(encParams, (ASN1Type)asn1pbe2Params);
            this.keyDerivationFunction = asn1pbe2Params.getKeyDerivationFunction();
            this.encryptionScheme = asn1pbe2Params.getEncryptionScheme();
        }
        catch (ASN1Exception e) {
            throw new IOException("ASN1Exception: " + e.getMessage());
        }
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (format != null && !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() throws IOException {
        PBES2ASN1Params asn1pbe2Params = new PBES2ASN1Params(this.keyDerivationFunction, this.encryptionScheme);
        try {
            return ASN1Tools.derEncode((ASN1Type)asn1pbe2Params);
        }
        catch (RuntimeException re) {
            throw new IOException(re.getMessage());
        }
    }

    public byte[] getEncoded(String format) throws IOException {
        if (format == null) {
            return this.getEncoded();
        }
        throw new IOException("decoding error - " + format + " not supported.");
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!paramSpec.isAssignableFrom(class$de$flexiprovider$core$pbe$PBES2ParameterSpec == null ? (class$de$flexiprovider$core$pbe$PBES2ParameterSpec = PBES2Parameters.class$("de.flexiprovider.core.pbe.PBES2ParameterSpec")) : class$de$flexiprovider$core$pbe$PBES2ParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return new PBES2ParameterSpec(this.keyDerivationFunction, this.encryptionScheme);
    }

    public String toString() {
        return "key derivation function OID: " + this.keyDerivationFunction.getAlgorithmOID().toString() + "\n" + "encryption scheme OID       :       " + this.encryptionScheme.getAlgorithmOID().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PBES2ASN1Params
    extends ASN1Sequence {
        private AlgorithmIdentifier keyDerivationFunction;
        private AlgorithmIdentifier encryptionScheme;

        public PBES2ASN1Params() {
            super(2);
            this.keyDerivationFunction = new AlgorithmIdentifier();
            this.encryptionScheme = new AlgorithmIdentifier();
            ((ArrayList)((Object)this)).add(this.keyDerivationFunction);
            ((ArrayList)((Object)this)).add(this.encryptionScheme);
        }

        public PBES2ASN1Params(AlgorithmIdentifier keyDerivationFunction, AlgorithmIdentifier encScheme) {
            super(2);
            this.keyDerivationFunction = keyDerivationFunction;
            this.encryptionScheme = encScheme;
            ((ArrayList)((Object)this)).add(this.keyDerivationFunction);
            ((ArrayList)((Object)this)).add(this.encryptionScheme);
        }

        public AlgorithmIdentifier getEncryptionScheme() {
            return this.encryptionScheme;
        }

        public AlgorithmIdentifier getKeyDerivationFunction() {
            return this.keyDerivationFunction;
        }
    }
}

