/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.kdf.PBKDF2ParameterSpec;
import de.flexiprovider.core.kdf.PBKDF2Parameters;
import de.flexiprovider.pki.AlgorithmIdentifier;

public class PBES2ParameterSpec
implements AlgorithmParameterSpec {
    private AlgorithmIdentifier keyDerivationFunction;
    private AlgorithmIdentifier encryptionScheme;

    public PBES2ParameterSpec(PBKDF2ParameterSpec kdfParamSpec, byte[] iv) {
        try {
            PBKDF2Parameters kdfParams = new PBKDF2Parameters();
            kdfParams.init(kdfParamSpec);
            ASN1ObjectIdentifier kdfOID = new ASN1ObjectIdentifier("1.2.840.113549.1.5.12");
            this.keyDerivationFunction = new AlgorithmIdentifier(kdfOID, kdfParams.getEncoded());
            ASN1ObjectIdentifier cipherOID = new ASN1ObjectIdentifier("1.2.840.113549.3.7");
            this.encryptionScheme = new AlgorithmIdentifier(cipherOID, (ASN1Type)new ASN1OctetString(iv));
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: " + e.getMessage());
        }
    }

    protected PBES2ParameterSpec(AlgorithmIdentifier keyDerivationFunction, AlgorithmIdentifier encryptionScheme) {
        this.keyDerivationFunction = keyDerivationFunction;
        this.encryptionScheme = encryptionScheme;
    }

    public AlgorithmIdentifier getEncryptionScheme() {
        return this.encryptionScheme;
    }

    public AlgorithmIdentifier getKeyDerivationFunction() {
        return this.keyDerivationFunction;
    }
}

