/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mersa;

import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mersa.MeRSAPrivateKey;
import de.flexiprovider.core.rsa.PKCS1Exception;
import de.flexiprovider.core.rsa.interfaces.RSAPublicKey;

public final class MeRSAOperations {
    private static final PKCS1Exception encryptionError = new PKCS1Exception("encryption error");
    private static final PKCS1Exception decryptionError = new PKCS1Exception("decryption error");

    private MeRSAOperations() {
    }

    static FlexiBigInt MeRSAEP(RSAPublicKey pubKey, FlexiBigInt m) throws PKCS1Exception {
        FlexiBigInt n = pubKey.getN();
        FlexiBigInt e = pubKey.getE();
        if (m.compareTo(n) > 0 || m.signum() < 0) {
            throw encryptionError;
        }
        if (e.equals(FlexiBigInt.valueOf(3L))) {
            return m.multiply(m).mod(n).multiply(m).mod(n);
        }
        return m.modPow(e, n);
    }

    public static FlexiBigInt MeRSADP(MeRSAPrivateKey privKey, FlexiBigInt c) throws PKCS1Exception {
        FlexiBigInt n = privKey.getN();
        FlexiBigInt p = privKey.getP();
        FlexiBigInt q = privKey.getQ();
        FlexiBigInt k = privKey.getK();
        FlexiBigInt dp = privKey.getDp();
        FlexiBigInt dq = privKey.getDq();
        FlexiBigInt e = privKey.getE();
        FlexiBigInt eInvP = privKey.getEInvP();
        FlexiBigInt pkInvQ = privKey.getCRTCoeff();
        if (c.compareTo(n) > 0 || c.signum() < 0) {
            throw decryptionError;
        }
        FlexiBigInt Mq = c.modPow(dq, q);
        FlexiBigInt K = c.modPow(dp.subtract(FlexiBigInt.ONE), p);
        FlexiBigInt A = K.multiply(c).mod(p);
        FlexiBigInt P = p;
        int i = 1;
        while (i < k.intValue()) {
            P = P.multiply(p);
            FlexiBigInt F = A.modPow(e, P);
            FlexiBigInt E = c.subtract(F).mod(P);
            FlexiBigInt B = E.multiply(K).multiply(eInvP).mod(P);
            A = A.add(B);
            ++i;
        }
        FlexiBigInt V = Mq.subtract(A).multiply(pkInvQ).mod(q);
        A = A.add(p.pow(k.intValue()).multiply(V));
        return A;
    }
}

