/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mars;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.mars.MARSKey;

public class MARS
extends BlockCipher {
    public static final String ALG_NAME = "MARS";
    private static final int blockSize = 16;
    private int[] K = new int[40];
    private static final int[] S = new int[]{164676729, 684261344, -2069205959, -1649577337, 2113903587, -735673503, -915562028, 2037697683, -2049943506, 709580549, 480340578, -1011013731, 253699557, 1365260079, -963264005, 1300230628, -1369478156, 225635910, -14426486, -1311797629, -246873374, 1050156610, -1946861898, 2135685292, -2090655869, 630653445, 1991239556, 981021140, 1334076496, 1550107638, 554327832, -963089882, 687138854, 979413020, -750737820, 2124947652, 1382451141, 2128466219, 849419549, -1667305338, -2131302351, -1418787667, 1459329875, -1959917220, -1232775506, -769324275, 692746017, -501239213, -1374460087, -399855994, -1825156860, -1723839898, 2024244444, -1231312821, 67397523, 601578526, 1187701206, 803373364, 1512192322, 409193819, -1047476509, 132102214, 1857587222, 755878986, -1530089895, 932734733, -872770413, 1330126149, -352547672, -619632170, -1337680352, 257165307, 1634195880, -772515997, 1303025347, 1005345112, -1414815724, -1228090879, 953558943, 40378901, -1892193067, 153887614, -1077582445, 847813932, -2058666347, 96181059, 2110610893, -1607560596, -85645339, 916570928, 873652654, -229116830, 1011817841, 815982601, 1759901009, -1671316924, 1575815864, 1976437192, -1772816066, 1770785994, 607957988, 721824663, 255561118, 14700767, -60989082, -480275832, -1065790195, 93433576, -1907155340, 1979594104, 795706010, -167042642, -1779897459, 1721321579, -1877115493, -43160015, 277916911, -530117160, -625809774, -848477339, -449235692, 989021680, 1648491597, 1175298979, 2077177641, -1947086368, 346734704, 361229653, 989691198, -755851775, 698995190, -273609645, -818182385, -1273719972, 1715758573, 38456007, 1504134337, 489240231, -598209882, -816362328, 67795472, 1826101255, -1969701300, -1395744669, -1019309387, -773791683, -1289596546, 546487571, 946547786, 1390992728, 1483042299, 1350697841, 1098979478, -482873474, -744509159, -914420234, 1761517595, -1588549915, 1428523362, -344984549, -674640518, -1508258402, -1125083786, 645054579, -268174532, 1253549323, 344199786, 1216063921, -1504720442, -157975223, 951085685, -578789427, 1674613967, -182675042, 447009603, -1203154284, -828404071, -1073948816, -943557172, 931419047, 2065808947, 964641213, 1318375729, -1832116328, 1494608465, -1711775305, -912782712, 494206303, -1331390984, 1632497360, -1250455830, 1497463085, -91176456, 871900340, -996781198, 1073141072, 1285947072, -2043614876, 1530903510, 2107796040, -1308417254, 69825812, 761500422, 783364425, 379867762, 1394891168, -1906358158, -110704679, 118656448, 222616418, -1345792723, 0x6316131, -667359282, 465837312, 976129039, -360479874, -1182502019, 330975377, -990332599, -1495880525, -1575629362, -2091285621, 1808902705, -176562862, 565788563, -183015551, 410910174, -380966026, 725155156, 1126031834, -1422309339, -1697446769, -538299734, 1704227811, 1648326755, -214668199, -1422215547, 860268811, 1800815678, -958529032, -1925046336, -1693527796, -1997430295, 1421996073, 2112542075, -1921276890, 1291130762, 1427799242, 446324488, -53063239, 627069314, -518011197, -1224894858, 863711271, -1211569388, -1637887952, 1800921940, -1382990601, 2115397773, 1485253225, 741328863, -477508410, 812879345, 136619828, -512132469, -1532439173, 1532827963, -928501605, 1945741688, 1933151538, 257513278, -371250429, -391792952, -2071132412, -1730178110, 1913265603, 1750017434, -1808029624, -1506344622, -2042929501, -780429429, 1838897391, 175115732, -1489160513, -1905653719, -2037007340, -480562105, -1824864920, -2003521502, 793844775, -570700740, 0x6662B6, 293372926, 1309848596, -1027823770, 976219152, -195681248, 1434005034, 1190516823, -824564274, -1017111237, 1811983174, -273900504, -1279045561, 1629355747, 628896263, -36338558, 991221839, 599706468, -1602882653, 143625901, 128840024, 2006357052, -87376067, -1063833395, -144205463, -633017875, 746933266, 898850723, 788888991, 1762010360, 481344253, 2064498118, -2129714245, -91055590, 1838586391, 1732417435, 1957461253, 17720772, -2036082333, -116935264, -805033005, 361594115, 679117397, -1146603921, 158260275, 563178107, 2008378246, -1793711367, -1496979888, -1930815535, -846437700, -1546243021, 898263293, 261856572, -693491365, -30197686, -1073712242, -848827601, -487887422, -1758229758, 113898054, 1100804525, 730054725, 925102474, -883216247, 369879767, 1565083222, 905488203, 508456094, 235965, 1732667520, -1273542607, -1393286222, -897492301, 1516475879, 808085445, -1948564373, 277843876, 270679770, -1833388917, 2134429934, -1423506988, 40031253, -1356707280, -1277654342, -122502225, -621285520, -862465097, -379499668, 732872692, 1895204815, 946639190, -838258971, 32013734, 1827217002, -1149514620, -946721760, -1657048579, 101597638, -682029291, 1308867399, 406591886, 1676587584, 769389722, 1834793556, -1841868625, -102677962, 2016941611, 1500671090, -2118752416, -1154931007, 1218498061, -1497347731, -1388097413, 1905084778, -1645193297, 1152499174, 88299228, -562238155, -719711349, 1644727497, 897778449, -915473246, 1752139500, -1904751768, 1675744952, -938502280, 2042925565, 457992178, 1919520125, 1580633137, -136749522, -1579988673, -589741250, -1989208750, 1271188090, -1496204556, -1515622964, 200248134, -1586889305, 1960788151, 1310754820, -1703582201, 59672520, 539041348, -1954884417, -968868043, 407429997, -2135052232, 509774108, 1681727751, -1090201864, 554249356, -163253367, 125321294, 2071506360, -1564136109, 1108703934, -1574617554, 2079585454, -2131389191, -1791912729, 2011927277, -1283364560, -628255946, -1086032791, -227699581, -294670635, 1899434549, -566075533, -1260019901, 2109615438, 758624645, 1239194211, -1732010600, 318884258, 949689279, 202922125, -1541291590, 2057537116, 1910539608, 1012726954, 2099485860, 43506141, -673437648, 1261928491, 1948822356, -1360133305, 1262467973, 1764699912, 323901326, 920248511, -1366597681, -306626865, 723985550, 386839023, 2110095318, 511053590, -1324128767, -2041701477, -672500967, 985166269, -811280529, -484714622, 230601833, -1413914527, 1399912541, -5210569, -634334981, -339118154, 194556943, 978128870, -548421013, 362607146, -1030170910, 729345898, 1638484672, -1420422777, 351183088, -552779420, 430928110};

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof MARSKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a MARS Key");
        }
        int keylen = key.getEncoded().length;
        if (keylen < 16 || keylen > 56 || (keylen & 7) != 0) {
            throw new InvalidKeyException("illegal key size for MARS");
        }
        return keylen << 3;
    }

    public int getCipherBlockSize() {
        return 16;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof MARSKey)) {
            throw new InvalidKeyException("not a MARS Key");
        }
        this.keyExpansion(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keyExpansion(byte[] key) {
        int t;
        int tmp;
        int[] T = new int[15];
        int[] B = new int[]{-1532439173, 1532827963, -928501605, 1945741688};
        int n = key.length / 4;
        int i = 0;
        while (i < 40) {
            this.K[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            int offset = i << 2;
            T[i] = key[offset + 0] & 0xFF | (key[offset + 1] & 0xFF) << 8 | (key[offset + 2] & 0xFF) << 16 | (key[offset + 3] & 0xFF) << 24;
            ++i;
        }
        T[n] = n;
        i = n + 1;
        while (i < 15) {
            T[i] = 0;
            ++i;
        }
        int j = 0;
        while (j < 4) {
            tmp = T[8] ^ T[13];
            T[0] = T[0] ^ (tmp << 3 | tmp >>> 29) ^ j;
            tmp = T[9] ^ T[14];
            T[1] = T[1] ^ (tmp << 3 | tmp >>> 29) ^ j + 4;
            i = 2;
            while (i < 7) {
                tmp = T[i + 8] ^ T[i - 2];
                T[i] = T[i] ^ (tmp << 3 | tmp >>> 29) ^ (i << 2) + j;
                ++i;
            }
            i = 7;
            while (i < 15) {
                tmp = T[i - 7] ^ T[i - 2];
                T[i] = T[i] ^ (tmp << 3 | tmp >>> 29) ^ (i << 2) + j;
                ++i;
            }
            t = 0;
            while (t < 4) {
                tmp = T[0] + S[T[14] & 0x1FF];
                T[0] = tmp << 9 | tmp >>> 23;
                i = 1;
                while (i < 15) {
                    tmp = T[i] + S[T[i - 1] & 0x1FF];
                    T[i] = tmp << 9 | tmp >>> 23;
                    ++i;
                }
                ++t;
            }
            i = j * 10;
            this.K[i] = T[0];
            this.K[i + 1] = T[4];
            this.K[i + 2] = T[8];
            this.K[i + 3] = T[12];
            this.K[i + 4] = T[1];
            this.K[i + 5] = T[5];
            this.K[i + 6] = T[9];
            this.K[i + 7] = T[13];
            this.K[i + 8] = T[2];
            this.K[i + 9] = T[6];
            ++j;
        }
        i = 5;
        while (i < 36) {
            j = this.K[i] & 3;
            int w = this.K[i] | 3;
            int M = 0;
            tmp = w;
            t = 1;
            while (t < 23) {
                if ((tmp & 0x3FF) == 1023) {
                    M |= 255 << t;
                    t += 10;
                    tmp >>>= 10;
                    while ((tmp & 1) == 1 & t < 32) {
                        M |= 1 << t - 2;
                        ++t;
                        tmp >>>= 1;
                    }
                    continue;
                }
                if ((tmp & 0x3FF) == 0) {
                    M |= 255 << t;
                    t += 10;
                    tmp >>>= 10;
                    while ((tmp & 1) == 0 & t < 32) {
                        M |= 1 << t - 2;
                        ++t;
                        tmp >>>= 1;
                    }
                    continue;
                }
                tmp >>>= 1;
                ++t;
            }
            if ((M & 2) != 0) {
                M ^= 2;
            }
            int p = B[j] << tmp | B[j] >>> 32 - (this.K[i - 1] & 0x1F);
            this.K[i] = w ^ p & M;
            i += 2;
        }
    }

    protected void singleBlockEncrypt(byte[] in, int inoffset, byte[] out, int outoffset) {
        int tmp;
        int d0 = in[inoffset + 0] & 0xFF | (in[inoffset + 1] & 0xFF) << 8 | (in[inoffset + 2] & 0xFF) << 16 | (in[inoffset + 3] & 0xFF) << 24;
        int d1 = in[inoffset + 4] & 0xFF | (in[inoffset + 5] & 0xFF) << 8 | (in[inoffset + 6] & 0xFF) << 16 | (in[inoffset + 7] & 0xFF) << 24;
        int d2 = in[inoffset + 8] & 0xFF | (in[inoffset + 9] & 0xFF) << 8 | (in[inoffset + 10] & 0xFF) << 16 | (in[inoffset + 11] & 0xFF) << 24;
        int d3 = in[inoffset + 12] & 0xFF | (in[inoffset + 13] & 0xFF) << 8 | (in[inoffset + 14] & 0xFF) << 16 | (in[inoffset + 15] & 0xFF) << 24;
        d0 += this.K[0];
        d1 += this.K[1];
        d2 += this.K[2];
        d3 += this.K[3];
        int i = 0;
        while (i < 8) {
            tmp = d0 >>> 24 | d0 << 8;
            d0 = (d1 ^ S[d0 & 0xFF]) + S[(tmp >>> 16 & 0xFF) + 256];
            d1 = d2 + S[tmp >>> 24 & 0xFF];
            d2 = d3 ^ S[(tmp & 0xFF) + 256];
            d3 = tmp;
            if (i == 0 | i == 4) {
                d3 += d2;
            }
            if (i == 1 | i == 5) {
                d3 += d0;
            }
            ++i;
        }
        int j = 2;
        i = 0;
        while (i < 16) {
            int M = d0 + this.K[j += 2];
            int R = (d0 << 13 | d0 >>> 19) * this.K[j + 1];
            int L = S[M & 0x1FF];
            R = R << 5 | R >>> 27;
            int k = R & 0x1F;
            M = M << k | M >>> 32 - k;
            L ^= R;
            R = R << 5 | R >>> 27;
            L ^= R;
            k = R & 0x1F;
            L = L << k | L >>> 32 - k;
            tmp = d0;
            if (i < 8) {
                d0 = d1 + L;
                d1 = d2 + M;
                d2 = d3 ^ R;
            } else {
                d0 = d1 ^ R;
                d1 = d2 + M;
                d2 = d3 + L;
            }
            d3 = tmp << 13 | tmp >>> 19;
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (i == 2 | i == 6) {
                d0 -= d3;
            }
            if (i == 3 | i == 7) {
                d0 -= d1;
            }
            tmp = d0 << 24 | d0 >>> 8;
            d0 = d1 ^ S[(d0 & 0xFF) + 256];
            d1 = d2 - S[tmp >>> 16 & 0xFF];
            d2 = d3 - S[(tmp >>> 8 & 0xFF) + 256] ^ S[tmp & 0xFF];
            d3 = tmp;
            ++i;
        }
        d1 -= this.K[37];
        d2 -= this.K[38];
        d3 -= this.K[39];
        out[outoffset + 0] = (byte)(d0 -= this.K[36]);
        out[outoffset + 1] = (byte)(d0 >> 8);
        out[outoffset + 2] = (byte)(d0 >> 16);
        out[outoffset + 3] = (byte)(d0 >> 24);
        out[outoffset + 4] = (byte)d1;
        out[outoffset + 5] = (byte)(d1 >> 8);
        out[outoffset + 6] = (byte)(d1 >> 16);
        out[outoffset + 7] = (byte)(d1 >> 24);
        out[outoffset + 8] = (byte)d2;
        out[outoffset + 9] = (byte)(d2 >> 8);
        out[outoffset + 10] = (byte)(d2 >> 16);
        out[outoffset + 11] = (byte)(d2 >> 24);
        out[outoffset + 12] = (byte)d3;
        out[outoffset + 13] = (byte)(d3 >> 8);
        out[outoffset + 14] = (byte)(d3 >> 16);
        out[outoffset + 15] = (byte)(d3 >> 24);
    }

    protected void singleBlockDecrypt(byte[] in, int inoffset, byte[] out, int outoffset) {
        int tmp;
        int d0 = in[inoffset + 0] & 0xFF | (in[inoffset + 1] & 0xFF) << 8 | (in[inoffset + 2] & 0xFF) << 16 | (in[inoffset + 3] & 0xFF) << 24;
        int d1 = in[inoffset + 4] & 0xFF | (in[inoffset + 5] & 0xFF) << 8 | (in[inoffset + 6] & 0xFF) << 16 | (in[inoffset + 7] & 0xFF) << 24;
        int d2 = in[inoffset + 8] & 0xFF | (in[inoffset + 9] & 0xFF) << 8 | (in[inoffset + 10] & 0xFF) << 16 | (in[inoffset + 11] & 0xFF) << 24;
        int d3 = in[inoffset + 12] & 0xFF | (in[inoffset + 13] & 0xFF) << 8 | (in[inoffset + 14] & 0xFF) << 16 | (in[inoffset + 15] & 0xFF) << 24;
        d0 += this.K[36];
        d1 += this.K[37];
        d2 += this.K[38];
        d3 += this.K[39];
        int i = 7;
        while (i >= 0) {
            tmp = d3 >>> 24 | d3 << 8;
            d3 = (d2 ^ S[tmp >>> 8 & 0xFF]) + S[256 + (tmp >>> 16 & 0xFF)];
            d2 = d1 + S[tmp >>> 24 & 0xFF];
            d1 = d0 ^ S[256 + (tmp & 0xFF)];
            d0 = tmp;
            if (i == 2 | i == 6) {
                d0 += d3;
            }
            if (i == 3 | i == 7) {
                d0 += d1;
            }
            --i;
        }
        int j = 36;
        i = 15;
        while (i >= 0) {
            tmp = d0;
            d0 = d3 >>> 13 | d3 << 19;
            int M = d0 + this.K[j -= 2];
            int R = (d0 << 13 | d0 >>> 19) * this.K[j + 1];
            int L = S[M & 0x1FF];
            R = R << 5 | R >>> 27;
            int k = R & 0x1F;
            M = M << k | M >>> 32 - k;
            L ^= R;
            R = R << 5 | R >>> 27;
            L ^= R;
            k = R & 0x1F;
            L = L << k | L >>> 32 - k;
            if (i < 8) {
                d3 = d2 ^ R;
                d2 = d1 - M;
                d1 = tmp - L;
            } else {
                d3 = d2 - L;
                d2 = d1 - M;
                d1 = tmp ^ R;
            }
            --i;
        }
        i = 7;
        while (i >= 0) {
            int tmp1 = d0;
            d0 = d3;
            if (i == 0 | i == 4) {
                d0 -= d2;
            }
            if (i == 1 | i == 5) {
                d0 -= tmp1;
            }
            tmp = d0 << 24 | d0 >>> 8;
            d3 = d2 ^ S[256 + (tmp >>> 24 & 0xFF)];
            d2 = d1 - S[tmp >>> 16 & 0xFF];
            d1 = tmp1 - S[256 + (tmp >>> 8 & 0xFF)] ^ S[tmp & 0xFF];
            d0 = tmp;
            --i;
        }
        d1 -= this.K[1];
        d2 -= this.K[2];
        d3 -= this.K[3];
        out[outoffset + 0] = (byte)(d0 -= this.K[0]);
        out[outoffset + 1] = (byte)(d0 >> 8);
        out[outoffset + 2] = (byte)(d0 >> 16);
        out[outoffset + 3] = (byte)(d0 >> 24);
        out[outoffset + 4] = (byte)d1;
        out[outoffset + 5] = (byte)(d1 >> 8);
        out[outoffset + 6] = (byte)(d1 >> 16);
        out[outoffset + 7] = (byte)(d1 >> 24);
        out[outoffset + 8] = (byte)d2;
        out[outoffset + 9] = (byte)(d2 >> 8);
        out[outoffset + 10] = (byte)(d2 >> 16);
        out[outoffset + 11] = (byte)(d2 >> 24);
        out[outoffset + 12] = (byte)d3;
        out[outoffset + 13] = (byte)(d3 >> 8);
        out[outoffset + 14] = (byte)(d3 >> 16);
        out[outoffset + 15] = (byte)(d3 >> 24);
    }
}

