/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.pbe.PBEParameterSpec;

public abstract class PBKDF1
extends KeyDerivation {
    private MessageDigest md;
    private byte[] secret;
    private byte[] salt;
    private int iterationCount;

    protected PBKDF1(MessageDigest md) {
        this.md = md;
    }

    public void init(byte[] secret, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secret == null) {
            throw new InvalidKeyException("null");
        }
        this.secret = ByteUtils.clone(secret);
        if (!(params instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBEParameterSpec kdfParams = (PBEParameterSpec)params;
        this.salt = kdfParams.getSalt();
        this.iterationCount = kdfParams.getIterationCount();
    }

    public byte[] deriveKey(int keySize) {
        if (keySize < 0) {
            return null;
        }
        this.md.update(this.secret);
        this.md.update(this.salt);
        byte[] out = this.md.digest();
        int i = this.iterationCount;
        while (--i >= 1) {
            this.md.update(out);
            out = this.md.digest();
        }
        byte[] keyBytes = new byte[keySize];
        System.arraycopy(out, 0, keyBytes, 0, keySize);
        return keyBytes;
    }

    public static final class SHA1
    extends PBKDF1 {
        public SHA1() {
            super(new de.flexiprovider.core.md.SHA1());
        }
    }

    public static final class MD5
    extends PBKDF1 {
        public MD5() {
            super(new de.flexiprovider.core.md.MD5());
        }
    }
}

