/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal.semanticallysecure;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.FlexiBigIntUtils;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPrivateKey;
import de.flexiprovider.core.elgamal.semanticallysecure.SSVElGamalPublicKey;

public class SSVElGamal
extends AsymmetricBlockCipher {
    public static final String ALG_NAME = "SSVElGamal";
    private FlexiBigInt modulusP;
    private FlexiBigInt modulusQ;
    private FlexiBigInt generator;
    private FlexiBigInt publicA;
    private FlexiBigInt secretA;
    private SecureRandom secureRandom = null;

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SSVElGamalPrivateKey) {
            return ((SSVElGamalPrivateKey)key).getModulusQ().bitLength();
        }
        if (key instanceof SSVElGamalPublicKey) {
            return ((SSVElGamalPublicKey)key).getModulusP().bitLength();
        }
        throw new InvalidKeyException("Unsupported key.");
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof SSVElGamalPublicKey)) {
            throw new InvalidKeyException("key is not an SSVElGamalPublicKey");
        }
        SSVElGamalPublicKey pubKey = (SSVElGamalPublicKey)key;
        this.modulusP = pubKey.getModulusP();
        this.modulusQ = pubKey.getModulusQ();
        this.generator = pubKey.getGenerator();
        this.publicA = pubKey.getPublicA();
        this.secureRandom = secureRandom;
        this.maxPlainTextSize = (this.modulusQ.bitLength() - 1 >> 3) - 1;
        if (this.maxPlainTextSize < 0) {
            throw new InvalidKeyException("Modulus bit length too small.");
        }
        this.cipherTextSize = this.modulusP.bitLength() + 7 >> 3 << 1;
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof SSVElGamalPrivateKey)) {
            throw new InvalidKeyException("Key is not an SSVElGamal Private Key");
        }
        SSVElGamalPrivateKey privKey = (SSVElGamalPrivateKey)key;
        this.modulusP = privKey.getModulusP();
        this.modulusQ = privKey.getModulusQ();
        this.generator = privKey.getGenerator();
        this.secretA = privKey.getA();
        this.maxPlainTextSize = (this.modulusQ.bitLength() - 1 >> 3) - 1;
        this.cipherTextSize = this.modulusP.bitLength() + 7 >> 3 << 1;
    }

    protected byte[] messageEncrypt(byte[] input) {
        FlexiBigInt b;
        FlexiBigInt pm = this.pad(input);
        pm = this.pm2sg(pm);
        FlexiBigInt pSubOne = this.modulusQ.subtract(FlexiBigInt.ONE);
        while ((b = new FlexiBigInt(this.modulusQ.bitLength() - 1, this.secureRandom)).compareTo(FlexiBigInt.ZERO) <= 0 || b.compareTo(pSubOne) >= 0) {
        }
        FlexiBigInt bigB = this.generator.modPow(b, this.modulusP);
        FlexiBigInt c = pm.multiply(this.publicA.modPow(b, this.modulusP)).mod(this.modulusP);
        byte[] bigBBytes = FlexiBigIntUtils.toMinimalByteArray(bigB);
        byte[] cBytes = FlexiBigIntUtils.toMinimalByteArray(c);
        byte[] result = new byte[this.cipherTextSize];
        System.arraycopy(bigBBytes, 0, result, (this.cipherTextSize >> 1) - bigBBytes.length, bigBBytes.length);
        System.arraycopy(cBytes, 0, result, this.cipherTextSize - cBytes.length, cBytes.length);
        return result;
    }

    private FlexiBigInt pad(byte[] mBytes) {
        byte[] pmBytes = new byte[mBytes.length + 1];
        pmBytes[0] = 1;
        System.arraycopy(mBytes, 0, pmBytes, 1, mBytes.length);
        return new FlexiBigInt(1, pmBytes);
    }

    private FlexiBigInt pm2sg(FlexiBigInt pm) {
        FlexiBigInt msgTemp = pm.add(FlexiBigInt.ONE);
        if (msgTemp.modPow(this.modulusQ, this.modulusP).equals(FlexiBigInt.ONE)) {
            return msgTemp;
        }
        return this.modulusP.subtract(msgTemp);
    }

    protected byte[] messageDecrypt(byte[] input) throws BadPaddingException {
        int cTextDiv2 = this.cipherTextSize >> 1;
        byte[] bigBBytes = new byte[cTextDiv2];
        System.arraycopy(input, 0, bigBBytes, 0, cTextDiv2);
        FlexiBigInt bigB = new FlexiBigInt(1, bigBBytes);
        byte[] cBytes = new byte[cTextDiv2];
        System.arraycopy(input, cTextDiv2, cBytes, 0, cTextDiv2);
        FlexiBigInt c = new FlexiBigInt(1, cBytes);
        FlexiBigInt pm = c.multiply(bigB.modPow(this.secretA.negate(), this.modulusP)).mod(this.modulusP);
        pm = this.sg2pm(pm);
        return this.unpad(pm);
    }

    private FlexiBigInt sg2pm(FlexiBigInt sgElement) {
        if (sgElement.compareTo(this.modulusQ) < 0 || sgElement.compareTo(this.modulusQ) == 0) {
            return sgElement.subtract(FlexiBigInt.ONE);
        }
        return this.modulusP.subtract(sgElement).subtract(FlexiBigInt.ONE);
    }

    private byte[] unpad(FlexiBigInt pm) throws BadPaddingException {
        byte[] mrBytes = pm.toByteArray();
        if (mrBytes[0] != 1) {
            throw new BadPaddingException("invalid ciphertext");
        }
        byte[] mBytes = new byte[mrBytes.length - 1];
        System.arraycopy(mrBytes, 1, mBytes, 0, mBytes.length);
        return mBytes;
    }
}

