/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal;

import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.elgamal.ElGamalPrivateKeySpec;

public class ElGamalPrivateKey
extends PrivateKey {
    private FlexiBigInt modulus;
    private FlexiBigInt generator;
    private FlexiBigInt publicA;
    private FlexiBigInt a;

    protected ElGamalPrivateKey(FlexiBigInt modulus, FlexiBigInt generator, FlexiBigInt publicA, FlexiBigInt a) {
        this.modulus = modulus;
        this.generator = generator;
        this.publicA = publicA;
        this.a = a;
    }

    protected ElGamalPrivateKey(ElGamalPrivateKeySpec keySpec) {
        this(keySpec.getModulus(), keySpec.getGenerator(), keySpec.getPublicA(), keySpec.getA());
    }

    public String getAlgorithm() {
        return "ElGamal";
    }

    public FlexiBigInt getModulus() {
        return this.modulus;
    }

    public FlexiBigInt getGenerator() {
        return this.generator;
    }

    public FlexiBigInt getPublicA() {
        return this.publicA;
    }

    public FlexiBigInt getA() {
        return this.a;
    }

    public String toString() {
        String result = "";
        result = result + "modulus  : 0x" + this.modulus.toString(16) + "\n";
        result = result + "generator: 0x" + this.generator.toString(16) + "\n";
        result = result + "public A : 0x" + this.publicA.toString(16) + "\n";
        result = result + "private a: 0x" + this.a.toString(16) + "\n";
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ElGamalPrivateKey)) {
            return false;
        }
        ElGamalPrivateKey otherKey = (ElGamalPrivateKey)obj;
        boolean value = this.modulus.equals(otherKey.modulus);
        value &= this.generator.equals(otherKey.generator);
        value &= this.publicA.equals(otherKey.publicA);
        return value &= this.a.equals(otherKey.a);
    }

    public int hashCode() {
        return this.modulus.hashCode() + this.generator.hashCode() + this.publicA.hashCode() + this.a.hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.3.14.7.2.1.1");
    }

    protected ASN1Type getAlgParams() {
        return new ASN1Null();
    }

    protected byte[] getKeyData() {
        ASN1Sequence keyData = new ASN1Sequence();
        keyData.add(ASN1Tools.createInteger(this.modulus));
        keyData.add(ASN1Tools.createInteger(this.generator));
        keyData.add(ASN1Tools.createInteger(this.publicA));
        keyData.add(ASN1Tools.createInteger(this.a));
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

