/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.elgamal;

import de.flexiprovider.api.AsymmetricBlockCipher;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.FlexiBigIntUtils;
import de.flexiprovider.core.elgamal.ElGamalPrivateKey;
import de.flexiprovider.core.elgamal.ElGamalPublicKey;

public class ElGamal
extends AsymmetricBlockCipher {
    public static final String ALG_NAME = "ElGamal";
    public static final String OID = "1.3.14.7.2.1.1";
    private FlexiBigInt modulus;
    private FlexiBigInt generator;
    private FlexiBigInt publicA;
    private FlexiBigInt secretA;
    private SecureRandom secureRandom = null;

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof ElGamalPrivateKey) {
            return ((ElGamalPrivateKey)key).getModulus().bitLength();
        }
        if (key instanceof ElGamalPublicKey) {
            return ((ElGamalPublicKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Unsupported key.");
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("key is not an ElGamalPublicKey");
        }
        ElGamalPublicKey pubKey = (ElGamalPublicKey)key;
        this.modulus = pubKey.getModulus();
        this.generator = pubKey.getGenerator();
        this.publicA = pubKey.getPublicA();
        this.secureRandom = secureRandom;
        this.maxPlainTextSize = (this.modulus.bitLength() - 1 >> 3) - 1;
        if (this.maxPlainTextSize < 0) {
            throw new InvalidKeyException("Modulus bit length too small.");
        }
        this.cipherTextSize = this.modulus.bitLength() + 7 >> 3 << 1;
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("Key is not a ElGamal Private Key");
        }
        ElGamalPrivateKey privKey = (ElGamalPrivateKey)key;
        this.modulus = privKey.getModulus();
        this.generator = privKey.getGenerator();
        this.secretA = privKey.getA();
        this.maxPlainTextSize = (this.modulus.bitLength() - 1 >> 3) - 1;
        this.cipherTextSize = this.modulus.bitLength() + 7 >> 3 << 1;
    }

    protected byte[] messageEncrypt(byte[] input) {
        FlexiBigInt b;
        FlexiBigInt pm = this.pad(input);
        FlexiBigInt pSubOne = this.modulus.subtract(FlexiBigInt.ONE);
        while ((b = new FlexiBigInt(this.modulus.bitLength() - 1, this.secureRandom)).compareTo(FlexiBigInt.ZERO) <= 0 || b.compareTo(pSubOne) >= 0) {
        }
        FlexiBigInt bigB = this.generator.modPow(b, this.modulus);
        FlexiBigInt c = pm.multiply(this.publicA.modPow(b, this.modulus)).mod(this.modulus);
        byte[] bigBBytes = FlexiBigIntUtils.toMinimalByteArray(bigB);
        byte[] cBytes = FlexiBigIntUtils.toMinimalByteArray(c);
        byte[] result = new byte[this.cipherTextSize];
        System.arraycopy(bigBBytes, 0, result, (this.cipherTextSize >> 1) - bigBBytes.length, bigBBytes.length);
        System.arraycopy(cBytes, 0, result, this.cipherTextSize - cBytes.length, cBytes.length);
        return result;
    }

    private FlexiBigInt pad(byte[] mBytes) {
        byte[] pmBytes = new byte[mBytes.length + 1];
        pmBytes[0] = 1;
        System.arraycopy(mBytes, 0, pmBytes, 1, mBytes.length);
        return new FlexiBigInt(1, pmBytes);
    }

    protected byte[] messageDecrypt(byte[] input) throws BadPaddingException {
        int cTextDiv2 = this.cipherTextSize >> 1;
        byte[] bigBBytes = new byte[cTextDiv2];
        System.arraycopy(input, 0, bigBBytes, 0, cTextDiv2);
        FlexiBigInt bigB = new FlexiBigInt(1, bigBBytes);
        byte[] cBytes = new byte[cTextDiv2];
        System.arraycopy(input, cTextDiv2, cBytes, 0, cTextDiv2);
        FlexiBigInt c = new FlexiBigInt(1, cBytes);
        FlexiBigInt pm = c.multiply(bigB.modPow(this.secretA.negate(), this.modulus)).mod(this.modulus);
        return this.unpad(pm);
    }

    private byte[] unpad(FlexiBigInt pm) throws BadPaddingException {
        byte[] mrBytes = pm.toByteArray();
        if (mrBytes[0] != 1) {
            throw new BadPaddingException("invalid ciphertext");
        }
        byte[] mBytes = new byte[mrBytes.length - 1];
        System.arraycopy(mrBytes, 1, mBytes, 0, mBytes.length);
        return mBytes;
    }
}

