/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.camellia;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.camellia.CamelliaKey;
import de.flexiprovider.core.camellia.CamelliaKeyGenParameterSpec;

public class CamelliaKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        CamelliaKeyGenParameterSpec camelliaParams;
        if (params == null) {
            camelliaParams = new CamelliaKeyGenParameterSpec();
        } else if (params instanceof CamelliaKeyGenParameterSpec) {
            camelliaParams = (CamelliaKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = camelliaParams.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        CamelliaKeyGenParameterSpec params = new CamelliaKeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        CamelliaKeyGenParameterSpec defaultParams = new CamelliaKeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new CamelliaKey(keyBytes);
    }
}

