/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api.keys;

import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.pki.PKCS8EncodedKeySpec;
import de.flexiprovider.pki.X509EncodedKeySpec;
import java.security.KeyFactorySpi;
import java.security.spec.InvalidKeySpecException;

public abstract class KeyFactory
extends KeyFactorySpi {
    protected java.security.PublicKey engineGeneratePublic(java.security.spec.KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec != null && !(keySpec instanceof KeySpec)) {
            if (keySpec instanceof java.security.spec.X509EncodedKeySpec) {
                X509EncodedKeySpec encKeySpec = new X509EncodedKeySpec((java.security.spec.X509EncodedKeySpec)keySpec);
                return this.generatePublic(encKeySpec);
            }
            throw new InvalidKeySpecException();
        }
        return this.generatePublic((KeySpec)keySpec);
    }

    protected java.security.PrivateKey engineGeneratePrivate(java.security.spec.KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec != null && !(keySpec instanceof KeySpec)) {
            if (keySpec instanceof java.security.spec.PKCS8EncodedKeySpec) {
                PKCS8EncodedKeySpec encKeySpec = new PKCS8EncodedKeySpec((java.security.spec.PKCS8EncodedKeySpec)keySpec);
                return this.generatePrivate(encKeySpec);
            }
            throw new InvalidKeySpecException();
        }
        return this.generatePrivate((KeySpec)keySpec);
    }

    protected final java.security.spec.KeySpec engineGetKeySpec(java.security.Key key, Class keySpec) throws InvalidKeySpecException {
        if (!(key instanceof Key)) {
            throw new InvalidKeySpecException();
        }
        return this.getKeySpec((Key)key, keySpec);
    }

    protected final java.security.Key engineTranslateKey(java.security.Key key) throws java.security.InvalidKeyException {
        if (!(key instanceof Key)) {
            throw new java.security.InvalidKeyException();
        }
        return this.translateKey((Key)key);
    }

    public abstract PublicKey generatePublic(KeySpec var1) throws de.flexiprovider.api.exceptions.InvalidKeySpecException;

    public abstract PrivateKey generatePrivate(KeySpec var1) throws de.flexiprovider.api.exceptions.InvalidKeySpecException;

    public abstract KeySpec getKeySpec(Key var1, Class var2) throws de.flexiprovider.api.exceptions.InvalidKeySpecException;

    public abstract Key translateKey(Key var1) throws InvalidKeyException;
}

