/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.provider;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.hoxt.packet.HttpMethod;
import org.jivesoftware.smackx.hoxt.packet.HttpOverXmppReq;
import org.jivesoftware.smackx.hoxt.provider.AbstractHttpOverXmppProvider;
import org.xmlpull.v1.XmlPullParser;

public class HttpOverXmppReqProvider
extends AbstractHttpOverXmppProvider {
    private static final String ELEMENT_REQ = "req";
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_RESOURCE = "resource";
    private static final String ATTRIBUTE_MAX_CHUNK_SIZE = "maxChunkSize";

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        String method = parser.getAttributeValue("", ATTRIBUTE_METHOD);
        String resource = parser.getAttributeValue("", ATTRIBUTE_RESOURCE);
        String version = parser.getAttributeValue("", "version");
        String maxChunkSize = parser.getAttributeValue("", ATTRIBUTE_MAX_CHUNK_SIZE);
        HttpMethod reqMethod = HttpMethod.valueOf(method);
        HttpOverXmppReq.Req req = new HttpOverXmppReq.Req(reqMethod, resource);
        req.setVersion(version);
        Boolean sipub = true;
        Boolean jingle = true;
        Boolean ibb = true;
        String sipubStr = parser.getAttributeValue("", "sipub");
        String ibbStr = parser.getAttributeValue("", "ibb");
        String jingleStr = parser.getAttributeValue("", "jingle");
        if (sipubStr != null) {
            sipub = Boolean.valueOf(sipubStr);
        }
        if (ibbStr != null) {
            ibb = Boolean.valueOf(ibbStr);
        }
        if (jingleStr != null) {
            jingle = Boolean.valueOf(jingleStr);
        }
        req.setIbb(ibb);
        req.setSipub(sipub);
        req.setJingle(jingle);
        if (maxChunkSize != null) {
            int maxChunkSizeValue = Integer.parseInt(maxChunkSize);
            req.setMaxChunkSize(maxChunkSizeValue);
        }
        this.parseHeadersAndData(parser, ELEMENT_REQ, req);
        HttpOverXmppReq packet = new HttpOverXmppReq();
        packet.setReq(req);
        return packet;
    }
}

