/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.packet;

import org.jivesoftware.smack.packet.PacketExtension;

public class Base64BinaryChunk
implements PacketExtension {
    public static final String ELEMENT_CHUNK = "chunk";
    public static final String ATTRIBUTE_STREAM_ID = "streamId";
    public static final String ATTRIBUTE_LAST = "last";
    private final String streamId;
    private final boolean last;
    private final String text;

    public Base64BinaryChunk(String text, String streamId, boolean last) {
        this.text = text;
        this.streamId = streamId;
        this.last = last;
    }

    public Base64BinaryChunk(String text, String streamId) {
        this(text, streamId, false);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public boolean isLast() {
        return this.last;
    }

    public String getText() {
        return this.text;
    }

    public String getElementName() {
        return ELEMENT_CHUNK;
    }

    public String getNamespace() {
        return "urn:xmpp:http";
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<chunk xmlns='urn:xmpp:http' streamId='");
        builder.append(this.streamId);
        builder.append("' last='");
        builder.append(Boolean.toString(this.last));
        builder.append("'>");
        builder.append(this.text);
        builder.append("</chunk>");
        return builder.toString();
    }
}

