/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.forward.Forwarded;

public class CarbonExtension
implements PacketExtension {
    public static final String NAMESPACE = "urn:xmpp:carbons:2";
    private Direction dir;
    private Forwarded fwd;

    public CarbonExtension(Direction dir, Forwarded fwd) {
        this.dir = dir;
        this.fwd = fwd;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public Forwarded getForwarded() {
        return this.fwd;
    }

    public String getElementName() {
        return this.dir.toString();
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        buf.append(this.fwd.toXML());
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public static class Private
    implements PacketExtension {
        public static final String ELEMENT = "private";

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return CarbonExtension.NAMESPACE;
        }

        public String toXML() {
            return "<private xmlns=\"urn:xmpp:carbons:2\"/>";
        }
    }

    public static enum Direction {
        received,
        sent;

    }
}

