/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.openid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationStatus;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.openid.OpenIDConsumer;
import org.springframework.security.openid.OpenIDConsumerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenID4JavaConsumer
implements OpenIDConsumer {
    private static final String DISCOVERY_INFO_KEY = DiscoveryInformation.class.getName();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConsumerManager consumerManager;
    private List<OpenIDAttribute> attributesToFetch = Collections.emptyList();

    public OpenID4JavaConsumer() throws ConsumerException {
        this.consumerManager = new ConsumerManager();
    }

    public OpenID4JavaConsumer(List<OpenIDAttribute> attributes) throws ConsumerException {
        this(new ConsumerManager(), attributes);
    }

    public OpenID4JavaConsumer(ConsumerManager consumerManager, List<OpenIDAttribute> attributes) throws ConsumerException {
        this.consumerManager = consumerManager;
        this.attributesToFetch = Collections.unmodifiableList(attributes);
    }

    @Override
    public String beginConsumption(HttpServletRequest req, String identityUrl, String returnToUrl, String realm) throws OpenIDConsumerException {
        AuthRequest authReq;
        List discoveries;
        try {
            discoveries = this.consumerManager.discover(identityUrl);
        }
        catch (DiscoveryException e) {
            throw new OpenIDConsumerException("Error during discovery", e);
        }
        DiscoveryInformation information = this.consumerManager.associate(discoveries);
        req.getSession().setAttribute(DISCOVERY_INFO_KEY, (Object)information);
        try {
            authReq = this.consumerManager.authenticate(information, returnToUrl, realm);
            if (!this.attributesToFetch.isEmpty()) {
                FetchRequest fetchRequest = FetchRequest.createFetchRequest();
                for (OpenIDAttribute attr : this.attributesToFetch) {
                    fetchRequest.addAttribute(attr.getName(), attr.getType(), attr.isRequired(), attr.getCount());
                }
                authReq.addExtension((MessageExtension)fetchRequest);
            }
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Error processing ConsumerManager authentication", e);
        }
        catch (ConsumerException e) {
            throw new OpenIDConsumerException("Error processing ConsumerManager authentication", e);
        }
        return authReq.getDestinationUrl(true);
    }

    @Override
    public OpenIDAuthenticationToken endConsumption(HttpServletRequest request) throws OpenIDConsumerException {
        Identifier verified;
        VerificationResult verification;
        boolean debug = this.logger.isDebugEnabled();
        ParameterList openidResp = new ParameterList(request.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)request.getSession().getAttribute(DISCOVERY_INFO_KEY);
        StringBuffer receivingURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(request.getQueryString());
        }
        try {
            verification = this.consumerManager.verify(receivingURL.toString(), openidResp, discovered);
        }
        catch (MessageException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        catch (DiscoveryException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        catch (AssociationException e) {
            throw new OpenIDConsumerException("Error verifying openid response", e);
        }
        Message authSuccess = verification.getAuthResponse();
        ArrayList<OpenIDAttribute> attributes = new ArrayList<OpenIDAttribute>(this.attributesToFetch.size());
        if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
            if (debug) {
                this.logger.debug((Object)"Extracting attributes retrieved by attribute exchange");
            }
            try {
                MessageExtension ext = authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                if (ext instanceof FetchResponse) {
                    FetchResponse fetchResp = (FetchResponse)ext;
                    for (OpenIDAttribute attr : this.attributesToFetch) {
                        List values = fetchResp.getAttributeValues(attr.getName());
                        if (values.isEmpty()) continue;
                        OpenIDAttribute fetched = new OpenIDAttribute(attr.getName(), attr.getType(), values);
                        fetched.setRequired(attr.isRequired());
                        attributes.add(fetched);
                    }
                }
            }
            catch (MessageException e) {
                attributes.clear();
                throw new OpenIDConsumerException("Attribute retrieval failed", e);
            }
            if (debug) {
                this.logger.debug((Object)("Retrieved attributes" + attributes));
            }
        }
        if ((verified = verification.getVerifiedId()) == null) {
            Identifier id = discovered.getClaimedIdentifier();
            return new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.FAILURE, id == null ? "Unknown" : id.getIdentifier(), "Verification status message: [" + verification.getStatusMsg() + "]", attributes);
        }
        return new OpenIDAuthenticationToken(OpenIDAuthenticationStatus.SUCCESS, verified.getIdentifier(), "some message", attributes);
    }
}

