/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    protected VersionGenerator versionGenerator;
    private static final Log log = LogFactory.getLog(VersionedEntryWrappingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void initialize(VersionGenerator versionGenerator) {
        this.versionGenerator = versionGenerator;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            ((VersionedPrepareCommand)command).setVersionsSeen(ctx.getCacheTransaction().getVersionsRead());
        }
        this.wrapEntriesForPrepare(ctx, command);
        EntryVersionsMap newVersionData = null;
        if (ctx.isOriginLocal() && !((LocalTransaction)ctx.getCacheTransaction()).isFromStateTransfer()) {
            newVersionData = this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, (VersionedPrepareCommand)command);
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isOriginLocal()) {
            newVersionData = this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, (VersionedPrepareCommand)command);
        }
        if (command.isOnePhaseCommit()) {
            ctx.getCacheTransaction().setUpdatedEntryVersions(((VersionedPrepareCommand)command).getVersionsSeen());
        }
        if (newVersionData != null) {
            retval = newVersionData;
        }
        if (command.isOnePhaseCommit()) {
            this.commitContextEntries(ctx, null, null);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            if (ctx.isOriginLocal()) {
                ((VersionedCommitCommand)command).setUpdatedVersions(ctx.getCacheTransaction().getUpdatedEntryVersions());
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isOriginLocal()) {
                ctx.getCacheTransaction().setUpdatedEntryVersions(((VersionedCommitCommand)command).getUpdatedVersions());
            }
            this.commitContextEntries(ctx, null, null);
        }
    }

    @Override
    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) {
        if (ctx.isInTxScope() && !this.isFromStateTransfer(ctx)) {
            EntryVersion updatedEntryVersion = (EntryVersion)((TxInvocationContext)ctx).getCacheTransaction().getUpdatedEntryVersions().get(entry.getKey());
            Metadata commitMetadata = updatedEntryVersion != null ? (metadata == null && entry.getMetadata() == null ? new EmbeddedMetadata.Builder().version(updatedEntryVersion).build() : (metadata != null ? metadata.builder().version(updatedEntryVersion).build() : entry.getMetadata().builder().version(updatedEntryVersion).build())) : (metadata != null ? metadata : entry.getMetadata());
            this.cdl.commitEntry(entry, commitMetadata, command, ctx);
        } else {
            this.cdl.commitEntry(entry, entry.getMetadata(), command, ctx);
        }
    }
}

