/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.TCPProxy.TCPProxy;
import homemonitor.TCPProxy.TCPProxyResponseInterface;
import homemonitor.Utility;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TCPProxyTests {
    private GatewayDeviceConnection gdc;
    private TCPProxyResponseInterface tcpResponse;
    private TCPProxy proxy;
    String mac = "fe:fe:fe:fe:fe:fe";
    String destip = "10.10.10.10";
    byte port = (byte)123;
    byte[] connectMsg;
    byte[] statusOK;
    long sessionId;

    public TCPProxyTests() {
        byte[] byArray = new byte[6];
        byArray[0] = 10;
        byArray[1] = 10;
        byArray[2] = 10;
        byArray[3] = 10;
        byArray[5] = 123;
        this.connectMsg = byArray;
        this.statusOK = new byte[1];
        this.sessionId = 1234L;
    }

    @Before
    public void setUp() {
        this.gdc = EasyMock.createMock(GatewayDeviceConnection.class);
        this.proxy = new TCPProxy(this.gdc);
        this.tcpResponse = EasyMock.createMock(TCPProxyResponseInterface.class);
    }

    @After
    public void tearDown() {
        this.tcpResponse = null;
        this.proxy = null;
        this.gdc = null;
    }

    @Test
    public void testTCPSessionWithAcks() {
        byte[] request60bytes = Utility.stringToByteArray(String.format("%1$60s", "60 bytes message"));
        byte[] request1000bytes = Utility.stringToByteArray(String.format("%1$1000s", "1000 bytes message"));
        byte[] request1188bytes = Utility.stringToByteArray(String.format("%1$1188s", "1188 bytes message"));
        byte[] request10000bytes = Utility.stringToByteArray(String.format("%1$10000s", "10000 bytes message"));
        byte[] response100bytes = Utility.stringToByteArray(String.format("%1$100s", "100 bytes test message"));
        byte[] response1000bytes = Utility.stringToByteArray(String.format("%1$1000s", "1000 bytes test message"));
        byte[] byArray = new byte[2];
        byArray[1] = (byte)response100bytes.length;
        byte[] ackResponse100bytes = byArray;
        byte[] ackResponse1000bytes = new byte[]{(byte)(response1000bytes.length / 256), (byte)(response1000bytes.length % 256)};
        GatewayDevice gd = new GatewayDevice("mac", "publicIpAddress", "localIpAddress");
        EasyMock.expect(this.gdc.createSession(this.mac, this.proxy)).andReturn(this.sessionId);
        EasyMock.expect(this.gdc.send(EasyMock.eq(128), EasyMock.eq(this.sessionId), EasyMock.aryEq(this.connectMsg))).andReturn(GDErrorCode.NoError);
        this.tcpResponse.accepted(this.sessionId);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect(this.gdc.send(EasyMock.eq(131), EasyMock.eq(this.sessionId), EasyMock.aryEq(request60bytes))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.gdc.findBySessionId(this.sessionId)).andReturn(gd);
        this.tcpResponse.received(this.sessionId, response100bytes);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect(this.gdc.send(EasyMock.eq(135), EasyMock.eq(this.sessionId), EasyMock.aryEq(ackResponse100bytes))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.gdc.send(EasyMock.eq(131), EasyMock.eq(this.sessionId), EasyMock.aryEq(request1000bytes))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.gdc.findBySessionId(this.sessionId)).andReturn(gd);
        this.tcpResponse.received(this.sessionId, response1000bytes);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect(this.gdc.send(EasyMock.eq(135), EasyMock.eq(this.sessionId), EasyMock.aryEq(ackResponse1000bytes))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.gdc.send(EasyMock.eq(131), EasyMock.eq(this.sessionId), EasyMock.aryEq(request1188bytes))).andReturn(GDErrorCode.NoError);
        int i = 0;
        while (i < request10000bytes.length / 1188) {
            EasyMock.expect(this.gdc.send(EasyMock.eq(131), EasyMock.eq(this.sessionId), EasyMock.aryEq(Arrays.copyOfRange(request10000bytes, i * 1188, (i + 1) * 1188)))).andReturn(GDErrorCode.NoError);
            ++i;
        }
        EasyMock.expect(this.gdc.send(EasyMock.eq(131), EasyMock.eq(this.sessionId), EasyMock.aryEq(Arrays.copyOfRange(request10000bytes, i * 1188, request10000bytes.length)))).andReturn(GDErrorCode.NoError);
        EasyMock.expect(this.gdc.send(EasyMock.eq(134), EasyMock.eq(this.sessionId), (byte[])EasyMock.isNull(null))).andReturn(GDErrorCode.NoError);
        EasyMock.replay(this.gdc);
        EasyMock.replay(this.tcpResponse);
        Assert.assertEquals(this.sessionId, this.proxy.connect(this.mac, this.destip, this.port, this.tcpResponse));
        this.proxy.receivedData(this.mac, 129, this.sessionId, null);
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.send(this.sessionId, request60bytes));
        this.proxy.receivedData(this.mac, 0, this.sessionId, this.statusOK);
        this.proxy.receivedData(this.mac, 130, this.sessionId, response100bytes);
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.send(this.sessionId, request1000bytes));
        this.proxy.receivedData(this.mac, 0, this.sessionId, this.statusOK);
        this.proxy.receivedData(this.mac, 130, this.sessionId, response1000bytes);
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.send(this.sessionId, request1188bytes));
        this.proxy.receivedData(this.mac, 0, this.sessionId, this.statusOK);
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.send(this.sessionId, request10000bytes));
        int j = 0;
        while (j < request10000bytes.length / 1188 + 1) {
            this.proxy.receivedData(this.mac, 0, this.sessionId, this.statusOK);
            ++j;
        }
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.disconnect(this.sessionId));
        this.proxy.receivedData(this.mac, 133, this.sessionId, null);
        Assert.assertEquals((Object)GDErrorCode.WrongSessionID, (Object)this.proxy.send(this.sessionId, null));
        EasyMock.verify(this.gdc);
        EasyMock.verify(this.tcpResponse);
    }

    @Test
    public void testTCPSessionWithoutAcks() {
        byte[] data = Utility.stringToByteArray("test message 1");
        byte[] data2 = Utility.stringToByteArray("test message 2");
        GatewayDevice gd = new GatewayDevice("mac", "publicIpAddress", "localIpAddress", 0, 0, 0, 1, 0, 0);
        EasyMock.expect(this.gdc.createSession(this.mac, this.proxy)).andReturn(this.sessionId);
        EasyMock.expect(this.gdc.send(EasyMock.eq(128), EasyMock.eq(this.sessionId), EasyMock.aryEq(this.connectMsg))).andReturn(GDErrorCode.NoError);
        this.tcpResponse.accepted(this.sessionId);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect(this.gdc.findBySessionId(this.sessionId)).andReturn(gd);
        EasyMock.expect(this.gdc.send(EasyMock.eq(131), EasyMock.eq(this.sessionId), EasyMock.aryEq(data))).andReturn(GDErrorCode.NoError);
        this.tcpResponse.received(this.sessionId, data2);
        EasyMock.expect(this.gdc.send(EasyMock.eq(134), EasyMock.eq(this.sessionId), (byte[])EasyMock.isNull(null))).andReturn(GDErrorCode.NoError);
        EasyMock.replay(this.gdc);
        EasyMock.replay(this.tcpResponse);
        Assert.assertEquals(this.sessionId, this.proxy.connect(this.mac, this.destip, this.port, this.tcpResponse));
        this.proxy.receivedData(this.mac, 129, this.sessionId, null);
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.send(this.sessionId, data));
        this.proxy.receivedData(this.mac, 130, this.sessionId, data2);
        Assert.assertEquals((Object)GDErrorCode.NoError, (Object)this.proxy.disconnect(this.sessionId));
        this.proxy.receivedData(this.mac, 133, this.sessionId, null);
        Assert.assertEquals((Object)GDErrorCode.WrongSessionID, (Object)this.proxy.send(this.sessionId, null));
        EasyMock.verify(this.gdc);
        EasyMock.verify(this.tcpResponse);
    }

    @Test
    public void testClosed() {
        EasyMock.expect(this.gdc.createSession(this.mac, this.proxy)).andReturn(this.sessionId);
        EasyMock.expect(this.gdc.send(EasyMock.eq(128), EasyMock.eq(this.sessionId), EasyMock.aryEq(this.connectMsg))).andReturn(GDErrorCode.NoError);
        this.tcpResponse.closed(this.sessionId);
        EasyMock.replay(this.gdc);
        EasyMock.replay(this.tcpResponse);
        Assert.assertEquals(this.sessionId, this.proxy.connect(this.mac, this.destip, this.port, this.tcpResponse));
        this.proxy.receivedData(this.mac, 133, this.sessionId, null);
        Assert.assertEquals((Object)GDErrorCode.WrongSessionID, (Object)this.proxy.send(this.sessionId, null));
        EasyMock.verify(this.gdc);
        EasyMock.verify(this.tcpResponse);
    }

    @Test
    public void testError() {
        EasyMock.expect(this.gdc.createSession(this.mac, this.proxy)).andReturn(this.sessionId);
        EasyMock.expect(this.gdc.send(EasyMock.eq(128), EasyMock.eq(this.sessionId), EasyMock.aryEq(this.connectMsg))).andReturn(GDErrorCode.NoError);
        this.tcpResponse.error(this.sessionId);
        EasyMock.replay(this.gdc);
        EasyMock.replay(this.tcpResponse);
        Assert.assertEquals(this.sessionId, this.proxy.connect(this.mac, this.destip, this.port, this.tcpResponse));
        this.proxy.receivedData(this.mac, 132, this.sessionId, null);
        Assert.assertEquals((Object)GDErrorCode.WrongSessionID, (Object)this.proxy.send(this.sessionId, null));
        EasyMock.verify(this.gdc);
        EasyMock.verify(this.tcpResponse);
    }
}

