/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.logs.LoggerConfigurator;
import homemonitor.logs.LoggerConfiguratorReceiverInterface;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerConfiguratorTests {
    private long sessionID = 123L;
    private String logConf = "logConf";
    private String deviceId = "fakeDeviceId";
    private GatewayDeviceConnection connection;
    private LoggerConfiguratorReceiverInterface receiver;
    private LoggerConfigurator loggerConfigurator;

    @Before
    public void setUp() {
        this.connection = EasyMock.createMock(GatewayDeviceConnection.class);
        this.receiver = EasyMock.createMock(LoggerConfiguratorReceiverInterface.class);
        this.loggerConfigurator = new LoggerConfigurator(this.connection);
    }

    @Test
    public void testCallSend() {
        EasyMock.expect(this.connection.createSession(this.deviceId, this.loggerConfigurator)).andReturn(this.sessionID);
        Assert.assertEquals((Object)GDErrorCode.WrongSessionID, (Object)this.loggerConfigurator.send(1L, this.logConf));
        byte[] payload = new byte[]{108, 111, 103, 67, 111, 110, 102};
        EasyMock.expect(this.connection.send(EasyMock.eq(21), EasyMock.eq(this.sessionID), EasyMock.aryEq(payload))).andReturn(GDErrorCode.NoError);
        EasyMock.replay(this.connection);
        this.loggerConfigurator.createSession(this.deviceId, this.receiver);
        this.loggerConfigurator.send(this.sessionID, this.logConf);
        this.receiver.received(LoggerConfigurationStatus.ERROR);
        this.receiver.received(LoggerConfigurationStatus.SUCCESS);
        EasyMock.replay(this.receiver);
        byte[] errorResponseData = new byte[]{18};
        this.loggerConfigurator.receivedData(this.deviceId, 0, this.sessionID, errorResponseData);
        byte[] successResponseData = new byte[1];
        this.loggerConfigurator.receivedData(this.deviceId, 0, this.sessionID, successResponseData);
        EasyMock.verify(this.connection);
        EasyMock.verify(this.receiver);
    }
}

