/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GatewayDeviceConnection;
import homemonitor.GatewayDeviceConnectionListener;
import homemonitor.SenderInterface;
import homemonitor.ServerBackendInterface;
import homemonitor.Utility;
import homemonitor.encryption.EncryptionHelper;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GatewayDeviceConnection.class})
public class GatewayDeviceConnectionTest {
    ServerBackendInterface serverBackendMockup;
    EncryptionHelper encryptionHelperMock = PowerMock.createMock(EncryptionHelper.class);
    GatewayDeviceConnection gdc = new GatewayDeviceConnection(this.encryptionHelperMock);
    String mac = "FE:FE:FE:FE:FE:FE";
    String mac2 = "ED:ED:ED:ED:ED:ED";
    String ip = "192.168.1.1";
    String ip2 = "192.168.1.2";
    String localip = "192.168.1.254";
    SenderInterface sender;
    SenderInterface sender2;
    private GatewayDeviceConnectionListener gdcListener1;
    private GatewayDeviceConnectionListener gdcListener2;
    private String restUrl = "thisNodeRestUrl";

    @Before
    public void setUp() throws URISyntaxException {
        this.gdcListener1 = PowerMock.createMock(GatewayDeviceConnectionListener.class);
        this.gdcListener2 = PowerMock.createMock(GatewayDeviceConnectionListener.class);
        this.serverBackendMockup = PowerMock.createMock(ServerBackendInterface.class);
        this.sender = PowerMock.createMock(SenderInterface.class);
        this.sender2 = PowerMock.createMock(SenderInterface.class);
        this.gdc.addListener(this.gdcListener1);
        this.gdc.addListener(this.gdcListener2);
        this.gdc.setRestUrl(this.restUrl);
    }

    @Test
    public void testHandshake() {
        byte[] helloMessage = new byte[44];
        helloMessage[0] = -105;
        helloMessage[1] = 1;
        helloMessage[2] = 0;
        helloMessage[3] = 36;
        int offset = 4;
        int i = 0;
        while (i < 4) {
            helloMessage[offset + i] = 0;
            ++i;
        }
        offset += 4;
        i = 0;
        while (i < 6) {
            helloMessage[offset + i] = -2;
            ++i;
        }
        offset += 6;
        i = 0;
        while (i < 4) {
            helloMessage[offset + i] = 10;
            ++i;
        }
        helloMessage[offset += 4] = 0;
        ++offset;
        i = 0;
        while (i < 3) {
            helloMessage[offset + i] = -1;
            ++i;
        }
        offset += 3;
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byte[] salt = byArray;
        System.arraycopy(salt, 0, helloMessage, offset, 16);
        helloMessage[(offset += 16) + 0] = 3;
        helloMessage[offset + 1] = 8;
        helloMessage[(offset += 2) + 0] = 12;
        helloMessage[offset + 1] = 34;
        helloMessage[offset += 2] = 1;
        helloMessage[++offset] = 4;
        ++offset;
        String tempDeviceId = new String("1234");
        this.gdc.setServerBackend(this.serverBackendMockup);
        byte[] replyMsg = new byte[24];
        replyMsg[0] = -105;
        replyMsg[1] = 2;
        replyMsg[2] = 0;
        replyMsg[3] = 16;
        replyMsg[4] = 0;
        replyMsg[5] = 0;
        replyMsg[6] = 0;
        replyMsg[7] = 0;
        int i2 = 0;
        while (i2 < 16) {
            replyMsg[8 + i2] = (byte)i2;
            ++i2;
        }
        this.serverBackendMockup.send(EasyMock.eq(tempDeviceId), EasyMock.aryEq(replyMsg));
        EasyMock.expect(this.encryptionHelperMock.encryption_sign_message(EasyMock.aryEq(salt))).andReturn(salt);
        this.gdcListener1.connected("FE:FE:FE:FE:FE:FE", this.ip, "10.10.10.10", this.restUrl);
        this.gdcListener2.connected("FE:FE:FE:FE:FE:FE", this.ip, "10.10.10.10", this.restUrl);
        this.serverBackendMockup.deviceVerified(EasyMock.eq(tempDeviceId), EasyMock.eq(this.mac));
        byte[] vrMessage = new byte[8];
        vrMessage[0] = -105;
        vrMessage[1] = 3;
        vrMessage[2] = 0;
        vrMessage[3] = 0;
        i2 = 0;
        while (i2 < 4) {
            vrMessage[4 + i2] = 0;
            ++i2;
        }
        PowerMock.replayAll(new Object[0]);
        this.gdc.receivedData(this.ip, tempDeviceId, ByteBuffer.wrap(helloMessage).compact());
        this.gdc.receivedData(this.ip, tempDeviceId, ByteBuffer.wrap(vrMessage).compact());
        PowerMock.verifyAll();
    }

    @Test
    public void testBadHandshake() {
        Random rd = new Random();
        String devId = "1234";
        this.gdc.setServerBackend(this.serverBackendMockup);
        int tries = 0;
        while (tries < 1) {
            int len = 8;
            while (len < 100) {
                this.serverBackendMockup.close(devId);
                byte[] replyMsg = new byte[8];
                replyMsg[0] = -105;
                replyMsg[1] = 6;
                int i = 2;
                while (i < 8) {
                    replyMsg[i] = 0;
                    ++i;
                }
                this.serverBackendMockup.send(EasyMock.eq(devId), EasyMock.aryEq(replyMsg));
                PowerMock.replayAll(new Object[0]);
                byte[] msg = new byte[len];
                int b = 0;
                while (b < msg.length) {
                    do {
                        msg[b] = (byte)rd.nextInt(256);
                    } while (msg[b] == -105);
                    ++b;
                }
                this.gdc.receivedData(this.ip, devId, ByteBuffer.wrap(msg).compact());
                PowerMock.verifyAll();
                PowerMock.resetAll(new Object[0]);
                ++len;
            }
            ++tries;
        }
    }

    @Test
    public void testCreateSession() {
        PowerMock.replayAll(new Object[0]);
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        long serviceId = this.gdc.createSession(this.mac, this.sender);
        Assert.assertFalse(serviceId == 0L);
        serviceId = this.gdc.createSession("test", this.sender);
        Assert.assertEquals(0L, serviceId);
        PowerMock.verifyAll();
    }

    @Test
    public void testTwoDevicesTwoSessions() {
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        this.gdc.addVerifiedDevice(this.mac2, this.ip2, this.localip);
        long sess1 = this.gdc.createSession(this.mac, this.sender);
        long sess2 = this.gdc.createSession(this.mac2, this.sender2);
        String mess1 = "hello one";
        String mess2 = "hello two";
        byte[] echoMessage1 = this.createEchoMessage(sess1, mess1);
        byte[] echoMessage2 = this.createEchoMessage(sess2, mess2);
        this.sender.receivedData(EasyMock.eq(this.mac), EasyMock.eq(-2), EasyMock.eq(sess1), EasyMock.aryEq(mess1.getBytes()));
        this.sender2.receivedData(EasyMock.eq(this.mac2), EasyMock.eq(-2), EasyMock.eq(sess2), EasyMock.aryEq(mess2.getBytes()));
        PowerMock.replayAll(new Object[0]);
        this.gdc.receivedData(this.ip, this.mac, ByteBuffer.wrap(echoMessage1).compact());
        this.gdc.receivedData(this.ip2, this.mac2, ByteBuffer.wrap(echoMessage2).compact());
        PowerMock.verifyAll();
    }

    private byte[] createEchoMessage(long sess1, String message) {
        byte[] echoMessage = new byte[8 + message.length()];
        echoMessage[0] = -105;
        echoMessage[1] = -2;
        echoMessage[2] = 0;
        echoMessage[3] = (byte)message.length();
        byte[] sessionIdArray = Utility.intToByteArray((int)sess1);
        int i = 0;
        while (i < 4) {
            echoMessage[4 + i] = sessionIdArray[i];
            ++i;
        }
        byte[] messageArray = Utility.stringToByteArray(message);
        System.arraycopy(messageArray, 0, echoMessage, 8, echoMessage.length - 8);
        return echoMessage;
    }

    @Test
    public void testDisconnect() {
        this.gdcListener1.disconnected("FE:FE:FE:FE:FE:FE", "192.168.1.1", "GDCLIENT_CLOSED", this.restUrl);
        this.gdcListener2.disconnected("FE:FE:FE:FE:FE:FE", "192.168.1.1", "GDCLIENT_CLOSED", this.restUrl);
        this.serverBackendMockup.close("FE:FE:FE:FE:FE:FE");
        this.sender.deviceDisconnected("FE:FE:FE:FE:FE:FE");
        PowerMock.replayAll(new Object[0]);
        this.gdc.setServerBackend(this.serverBackendMockup);
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        long sessionId = this.gdc.createSession(this.mac, this.sender);
        Assert.assertTrue(sessionId != 0L);
        this.gdc.deviceDisconnected(this.mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceiveIncompleteMessage() {
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        long sessionId = this.gdc.createSession(this.mac, this.sender);
        Assert.assertTrue(sessionId != 0L);
        PowerMock.replayAll(new Object[0]);
        byte[] echoMessage = new byte[10];
        echoMessage[0] = -105;
        echoMessage[1] = -2;
        echoMessage[2] = 0;
        String message = "hello";
        echoMessage[3] = (byte)message.length();
        byte[] sessionIdArray = Utility.intToByteArray((int)sessionId);
        int i = 0;
        while (i < 4) {
            echoMessage[4 + i] = sessionIdArray[i];
            ++i;
        }
        byte[] messageArray = Utility.stringToByteArray(message);
        System.arraycopy(messageArray, 0, echoMessage, 8, echoMessage.length - 8);
        this.gdc.receivedData(this.ip, this.mac, ByteBuffer.wrap(echoMessage).compact());
        PowerMock.verifyAll();
        PowerMock.resetAll(new Object[0]);
        this.sender.receivedData(EasyMock.eq(this.mac), EasyMock.eq(-2), EasyMock.eq(sessionId), EasyMock.aryEq(message.getBytes()));
        PowerMock.replayAll(new Object[0]);
        int remainingSize = message.length() - echoMessage.length + 8;
        byte[] restOfMessage = new byte[remainingSize];
        System.arraycopy(messageArray, echoMessage.length - 8, restOfMessage, 0, remainingSize);
        this.gdc.receivedData(this.ip, this.mac, ByteBuffer.wrap(restOfMessage).compact());
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivePartOfMessage() {
        this.gdcListener1.disconnected(this.mac, this.ip, "RESTART_REQUESTED", this.restUrl);
        this.gdcListener2.disconnected(this.mac, this.ip, "RESTART_REQUESTED", this.restUrl);
        this.gdc.setServerBackend(this.serverBackendMockup);
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        long sessionId = this.gdc.createSession(this.mac, this.sender);
        Assert.assertTrue(sessionId != 0L);
        byte[] resetMsg = new byte[]{-105, 6, 0, 0, 0, 0, 0, 0};
        this.serverBackendMockup.send(EasyMock.eq(this.mac), EasyMock.aryEq(resetMsg));
        this.serverBackendMockup.close(EasyMock.eq(this.mac));
        this.sender.deviceDisconnected(EasyMock.eq(this.mac));
        PowerMock.replayAll(new Object[0]);
        int invDataOffset = 5;
        byte[] echoMessage = new byte[10 + invDataOffset];
        int i = 0;
        while (i < invDataOffset) {
            echoMessage[i] = (byte)i;
            ++i;
        }
        echoMessage[invDataOffset + 0] = -105;
        echoMessage[invDataOffset + 1] = -2;
        echoMessage[invDataOffset + 2] = 0;
        String message = "hello there";
        echoMessage[invDataOffset + 2 + 1] = (byte)message.length();
        byte[] sessionIdArray = Utility.intToByteArray((int)sessionId);
        int i2 = 0;
        while (i2 < 4) {
            echoMessage[invDataOffset + 4 + i2] = sessionIdArray[i2];
            ++i2;
        }
        byte[] messageArray = Utility.stringToByteArray(message);
        System.arraycopy(messageArray, 0, echoMessage, invDataOffset + 8, echoMessage.length - 8 - invDataOffset);
        this.gdc.receivedData(this.ip, this.mac, ByteBuffer.wrap(echoMessage).compact());
        PowerMock.verifyAll();
    }

    @Test
    public void testRestart() {
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        this.gdc.setServerBackend(this.serverBackendMockup);
        this.gdcListener1.disconnected("FE:FE:FE:FE:FE:FE", "192.168.1.1", "RESTART_REQUESTED", this.restUrl);
        this.gdcListener2.disconnected("FE:FE:FE:FE:FE:FE", "192.168.1.1", "RESTART_REQUESTED", this.restUrl);
        byte[] resetMsg = new byte[]{-105, 6, 0, 0, 0, 0, 0, 0};
        this.serverBackendMockup.send(EasyMock.eq(this.mac), EasyMock.aryEq(resetMsg));
        this.serverBackendMockup.close(EasyMock.eq(this.mac));
        PowerMock.replayAll(new Object[0]);
        this.gdc.restartDevice(this.mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testForceUpgrade() {
        this.gdc.addVerifiedDevice(this.mac, this.ip, this.localip);
        this.gdc.setServerBackend(this.serverBackendMockup);
        this.gdcListener1.disconnected("FE:FE:FE:FE:FE:FE", "192.168.1.1", "UPGRADE_REQUESTED", this.restUrl);
        this.gdcListener2.disconnected("FE:FE:FE:FE:FE:FE", "192.168.1.1", "UPGRADE_REQUESTED", this.restUrl);
        byte[] resetMsg = new byte[]{-105, 7, 0, 0, 0, 0, 0, 0};
        this.serverBackendMockup.send(EasyMock.eq(this.mac), EasyMock.aryEq(resetMsg));
        this.serverBackendMockup.close(EasyMock.eq(this.mac));
        PowerMock.replayAll(new Object[0]);
        this.gdc.forceUpgrade(this.mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceiveLogs() {
        String message = "[test log string]";
        byte[] logMessage = new byte[8 + message.length()];
        logMessage[0] = -105;
        logMessage[1] = 20;
        logMessage[2] = 0;
        logMessage[3] = (byte)message.length();
        byte[] messageArray = Utility.stringToByteArray(message);
        System.arraycopy(messageArray, 0, logMessage, 8, logMessage.length - 8);
        this.gdcListener1.receivedLogs("FE:FE:FE:FE:FE:FE", message);
        this.gdcListener2.receivedLogs("FE:FE:FE:FE:FE:FE", message);
        PowerMock.replayAll(new Object[0]);
        this.gdc.receivedData(this.ip, this.mac, ByteBuffer.wrap(logMessage).compact());
        PowerMock.verifyAll();
    }
}

