/*
 * Decompiled with CFR 0.152.
 */
package tests;

import codec.asn1.ASN1Exception;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.FlexiCoreProvider;
import de.flexiprovider.ec.FlexiECProvider;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.parameters.CurveRegistry;
import homemonitor.ASN1Signature;
import homemonitor.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class ECDSAKeyGen {
    public static void main(String[] args) {
        ECDSAKeyGen gen = new ECDSAKeyGen();
        byte[] salt = new byte[16];
        int i = 0;
        while (i < 16) {
            salt[i] = (byte)i;
            ++i;
        }
        byte[] signature = gen.signSalt(salt);
        ECDSAKeyGen.verify(salt, signature);
    }

    public void genereateKey() {
        Security.addProvider(new FlexiCoreProvider());
        Security.addProvider(new FlexiECProvider());
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("ECDSA", "FlexiEC");
            CurveRegistry.Secp128r2 ecParams = new CurveRegistry.Secp128r2();
            generator.initialize(ecParams, (SecureRandom)new MyRandom());
            KeyPair pair = generator.generateKeyPair();
            ECPublicKey ecPubKey = (ECPublicKey)pair.getPublic();
            System.out.println("x: " + Utility.byteArrayToHexString(ecPubKey.getW().getX().toByteArray(), 0, ecPubKey.getW().getX().toByteArray().length, " "));
            System.out.println("y: " + Utility.byteArrayToHexString(ecPubKey.getW().getY().toByteArray(), 0, ecPubKey.getW().getY().toByteArray().length, " "));
            ECPrivateKey privKey = (ECPrivateKey)pair.getPrivate();
            System.out.println("s: " + Utility.byteArrayToHexString(privKey.getS().toByteArray(), 0, privKey.getS().toByteArray().length, " "));
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(ecPubKey.getEncoded());
            FileOutputStream fos = new FileOutputStream("/Users/tomek/ECPublicKey.bin");
            fos.write(x509EncodedKeySpec.getEncoded());
            fos.close();
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privKey.getEncoded());
            FileOutputStream f_out = new FileOutputStream("/Users/tomek/ECPrivateKey.bin");
            f_out.write(pkcs8EncodedKeySpec.getEncoded());
            f_out.close();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] signSalt(byte[] salt) {
        Security.addProvider(new FlexiCoreProvider());
        Security.addProvider(new FlexiECProvider());
        try {
            File filePrivateKey = new File("/Users/tomek/ECPrivateKey.bin");
            FileInputStream fis = new FileInputStream("/Users/tomek/ECPrivateKey.bin");
            byte[] encodedPrivateKey = new byte[(int)filePrivateKey.length()];
            fis.read(encodedPrivateKey);
            fis.close();
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "FlexiEC");
            ECPrivateKey privKey = (ECPrivateKey)keyFactory.generatePrivate(privKeySpec);
            System.out.println("s: " + Utility.byteArrayToHexString(privKey.getS().toByteArray(), 0, privKey.getS().toByteArray().length, " "));
            Signature sig = Signature.getInstance("SHA1withECDSA", "FlexiEC");
            sig.initSign(privKey, new MyRandom());
            sig.setParameter(new CurveRegistry.Secp128r2());
            sig.update(salt);
            byte[] sigAsn1 = sig.sign();
            ASN1Signature asnsig = new ASN1Signature();
            ASN1Tools.derDecode(sigAsn1, asnsig);
            byte[] signature = new byte[32];
            byte[] r_bytes = asnsig.getR().getBigInteger().toByteArray();
            byte[] s_bytes = asnsig.getS().getBigInteger().toByteArray();
            System.out.println("r = " + Utility.byteArrayToHexString(r_bytes, 0, r_bytes.length, " "));
            System.out.println("s = " + Utility.byteArrayToHexString(s_bytes, 0, s_bytes.length, " "));
            int i = 0;
            while (i < 16) {
                signature[i] = r_bytes[i + r_bytes.length - 16];
                ++i;
            }
            i = 0;
            while (i < 16) {
                signature[i + 16] = s_bytes[i + s_bytes.length - 16];
                ++i;
            }
            System.out.println("signature = " + Utility.byteArrayToHexString(signature, 0, signature.length, " "));
            return sigAsn1;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (java.security.InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void verify(byte[] salt, byte[] signature) {
        try {
            File filePublicKey = new File("/Users/tomek/ECPublicKey.bin");
            FileInputStream fis = new FileInputStream("/Users/tomek/ECPublicKey.bin");
            byte[] encodedPublicKey = new byte[(int)filePublicKey.length()];
            fis.read(encodedPublicKey);
            fis.close();
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sig = Signature.getInstance("SHA1withECDSA", "FlexiEC");
            sig.initVerify(publicKey);
            sig.update(salt);
            System.out.println("verified = " + sig.verify(signature));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (java.security.InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
    }

    public class MyRandom
    extends SecureRandom {
        private static final long serialVersionUID = 1L;

        @Override
        public void nextBytes(byte[] bytes) {
            System.out.println("nextBytes: " + bytes.length);
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = (byte)i;
                ++i;
            }
        }
    }
}

