/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.enums;

import java.lang.reflect.Field;
import java.util.ArrayList;

public class EnumUtils {
    public static <Type extends Enum<Type>> boolean isEnum(Class<Type> e, String s) {
        try {
            Enum.valueOf(e, s);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public static <Type extends Enum<Type>> Type toEnum(Class<Type> e, String s) {
        try {
            return Enum.valueOf(e, s);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static <Type extends Enum<Type>> ArrayList<Type> toEnum(Class<Type> e, String[] values) {
        ArrayList<Type> enumValues = new ArrayList<Type>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            Type enumValue = EnumUtils.toEnum(e, value);
            if (enumValue != null) {
                enumValues.add(enumValue);
            }
            ++n2;
        }
        if (enumValues.isEmpty()) {
            return null;
        }
        return enumValues;
    }

    public static <Type extends Enum<Type>> Type toEnum(Type[] es, int ordinal) {
        Type[] TypeArray = es;
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            Type typeValue = TypeArray[n2];
            if (((Enum)typeValue).ordinal() == ordinal) {
                return typeValue;
            }
            ++n2;
        }
        return null;
    }

    public static Enum<?> getInstanceFromField(Field field) {
        ?[] enumValues = field.getType().getEnumConstants();
        return (Enum)enumValues[0];
    }

    public static Enum<?>[] getValuesFromField(Field field) {
        ?[] enumValues = field.getType().getEnumConstants();
        return (Enum[])enumValues;
    }
}

