/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.logs;

import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.Utility;
import homemonitor.logs.LoggerConfiguratorInterface;
import homemonitor.logs.LoggerConfiguratorReceiverInterface;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LoggerConfigurator
extends Application
implements LoggerConfiguratorInterface {
    private static final int CONFIGURELOGS_TAG = 21;
    private static Logger log = Logger.getLogger(LoggerConfigurator.class);
    private GatewayDeviceConnectionInterface connection;
    private HashMap<Long, LoggerConfiguratorReceiverInterface> sessionHandlers = new HashMap();

    public LoggerConfigurator(GatewayDeviceConnectionInterface connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        HashMap<Long, LoggerConfiguratorReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            LoggerConfiguratorReceiverInterface receiver = this.sessionHandlers.remove(sessionId);
            if (receiver != null) {
                receiver.deviceDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        LoggerConfiguratorReceiverInterface response;
        HashMap<Long, LoggerConfiguratorReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            response = this.sessionHandlers.get(sessionId);
        }
        if (response == null) {
            return;
        }
        if (tag == 0) {
            if (data[0] != 0) {
                log.warn("LoggerConfigurator got Status Error (" + data[0] + ") from GD.");
                response.received(LoggerConfigurationStatus.ERROR);
            } else {
                response.received(LoggerConfigurationStatus.SUCCESS);
            }
        } else {
            log.warn("Received unexpected identifier: " + tag + ".");
        }
        this.sessionDelete(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSession(String deviceID, LoggerConfiguratorReceiverInterface receiver) {
        long sessionID = this.connection.createSession(deviceID, this);
        if (sessionID != 0L) {
            HashMap<Long, LoggerConfiguratorReceiverInterface> hashMap = this.sessionHandlers;
            synchronized (hashMap) {
                this.sessionHandlers.put(sessionID, receiver);
            }
            this.sessionAdd(deviceID, sessionID);
        }
        return sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(long sessionID, String loggerConfiguration) {
        log.debug("start send(sessionID=" + sessionID + ", loggerConfiguration=" + loggerConfiguration + ")");
        HashMap<Long, LoggerConfiguratorReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            if (!this.sessionHandlers.containsKey(sessionID) || sessionID == 0L) {
                log.warn("No device connected.");
                return GDErrorCode.WrongSessionID;
            }
        }
        byte[] payload = this.preparePayload(loggerConfiguration);
        GDErrorCode status = this.connection.send(21, sessionID, payload);
        log.debug("exit send(sessionID=" + sessionID + ", loggerConfiguration=" + loggerConfiguration + "): " + (Object)((Object)status));
        return status;
    }

    private byte[] preparePayload(String message) {
        return Utility.stringToByteArray(message);
    }
}

