/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.execcmd;

import homemonitor.execcmd.ExecCmdCallback;
import homemonitor.execcmd.ExecCmdTransmitter;
import java.nio.ByteBuffer;

class ExecCmdHandler {
    private ExecCmdCallback callback;
    private ExecCmdTransmitter transmitter;
    private StringBuilder buffer = new StringBuilder();

    void executeCommand(String command) throws ExecCmdTransmitter.SendException {
        this.transmitter.sendData(this, 80, command.getBytes());
    }

    public ExecCmdHandler(ExecCmdTransmitter transmitter, ExecCmdCallback callback) {
        this.callback = callback;
        this.transmitter = transmitter;
    }

    public boolean receivedData(int tag, byte[] data) {
        switch (tag) {
            case 81: {
                this.buffer.append(new String(data));
                return false;
            }
            case 82: {
                if (data.length != 4) {
                    this.callback.execCmdError(this);
                    break;
                }
                int statusCode = ByteBuffer.wrap(data).getInt();
                this.callback.execCmdEffect(this, this.buffer.toString(), statusCode);
                break;
            }
            case 0: {
                byte code = ByteBuffer.wrap(data).get();
                if (code == 0) {
                    return false;
                }
            }
            default: {
                this.callback.execCmdError(this);
            }
        }
        return true;
    }
}

