/*
 * Decompiled with CFR 0.152.
 */
package homemonitor;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class Utility {
    private static Logger log = Logger.getLogger(Utility.class);

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static final long byteArrayToInt(byte[] b) {
        return Utility.byteArrayToInt(b, 0, b.length);
    }

    public static final int byteArrayToInt(byte[] b, int pos, int length) {
        int result = 0;
        int i = 0;
        while (i < length) {
            result += (b[pos + i] & 0xFF) << 8 * (length - i - 1);
            ++i;
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    private static final String byteArrayToString(byte[] data, int offset, int size, String delim, boolean hex) {
        String result = new String();
        int i = offset;
        while (i < offset + size) {
            int value = data[i] < 0 ? data[i] + 256 : data[i];
            result = hex ? String.valueOf(result) + String.format("%02X", value) : String.valueOf(result) + Integer.toString(value);
            if (i != offset + size - 1) {
                result = String.valueOf(result) + delim;
            }
            ++i;
        }
        return result;
    }

    public static final String byteArrayASCIIToString(byte[] data, int offset, int size, char delim) {
        String result = new String();
        int i = offset;
        while (i < offset + size) {
            int value;
            int n = value = data[i] < 0 ? data[i] + 256 : data[i];
            if (delim != '\u0000' && value == delim) break;
            result = String.valueOf(result) + (char)value;
            ++i;
        }
        return result;
    }

    public static final String byteArrayASCIIToString(byte[] data, int offset) {
        return Utility.byteArrayASCIIToString(data, offset, data.length - offset, '\u0000');
    }

    public static final String byteArrayASCIIToString(byte[] data) {
        return Utility.byteArrayASCIIToString(data, 0);
    }

    public static final String byteArrayToString(byte[] data, String delim) {
        return Utility.byteArrayToString(data, 0, data.length, delim, false);
    }

    public static final String byteArrayToString(byte[] data, int offset, int size, String delim) {
        return Utility.byteArrayToString(data, offset, size, delim, false);
    }

    public static final String byteArrayToHexString(byte[] data, int offset, int size, String delim) {
        return Utility.byteArrayToString(data, offset, size, delim, true);
    }

    public static byte[] stringToByteArray(String message) {
        byte[] result = new byte[message.length()];
        int i = 0;
        while (i < message.length()) {
            result[i] = (byte)message.charAt(i);
            ++i;
        }
        return result;
    }

    public static String generateMD5(String input) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(input.getBytes());
            byte[] md5hash = messageDigest.digest();
            BigInteger number = new BigInteger(1, md5hash);
            return number.toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            log.error("Cannot find digest algorithm");
            return null;
        }
    }

    public static byte[] ipAddressToByteArray(String ipAddress) {
        byte[] result = new byte[4];
        String[] octets = ipAddress.split("\\.");
        int i = 0;
        while (i < 4) {
            int octet = Integer.parseInt(octets[i]);
            result[i] = (byte)octet;
            ++i;
        }
        return result;
    }

    public static String byteArrayASCIIToString(byte[] data, int offset, int size) {
        return Utility.byteArrayASCIIToString(data, offset, size, '\u0000');
    }
}

