/*
 * Decompiled with CFR 0.152.
 */
package homemonitor;

import homemonitor.Session;
import java.util.ArrayList;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;

public class GatewayDevice {
    public String mac;
    public String publicIpAddress;
    public String reportedIpAddress;
    public String localIpAddress = null;
    public final byte versionMajor;
    public final byte versionMinor;
    public short buildNo;
    public byte deviceType;
    public byte deviceHash;
    public long lastAlive;
    public Date connectedDate;
    ArrayList<Session> sessions = new ArrayList();
    private byte supportedServices = 0;
    private short upnpPort = (short)15800;
    private boolean upnpOldPort = false;
    private long upnpLastCheck = System.currentTimeMillis();
    public boolean encryptedControlConnection = false;
    byte[] PublicKey = new byte[32];
    byte[] sharedSecretKey = new byte[32];
    SecretKeySpec secretKey = null;

    static GatewayDevice createStub() {
        return new GatewayDevice("", "", "");
    }

    public GatewayDevice(String mac, String publicIpAddress, String localIpAddress) {
        this(mac, publicIpAddress, localIpAddress, 0, 0, 0, 0, 0, 0);
    }

    public GatewayDevice(String mac, String publicIpAddress, String localIpAddress, byte versionMajor, byte versionMinor, short buildNo, byte deviceType, byte deviceHash, byte supportedServices) {
        this.mac = mac;
        this.publicIpAddress = publicIpAddress;
        this.localIpAddress = localIpAddress;
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.buildNo = buildNo;
        this.deviceType = deviceType;
        this.deviceHash = deviceHash;
        this.connectedDate = new Date();
        this.supportedServices = versionMajor <= 2 || versionMajor == 3 && versionMinor <= 5 ? (byte)19 : supportedServices;
        this.updateAlive();
    }

    public synchronized void updateAlive() {
        this.lastAlive = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        ArrayList<Session> arrayList = this.sessions;
        synchronized (arrayList) {
            for (Session session : this.sessions) {
                if (session.sender == null) continue;
                session.sender.deviceDisconnected(session.deviceId);
            }
            this.sessions.clear();
        }
    }

    public boolean isGateway() {
        return this.getServiceField(ServiceType.Gateway);
    }

    private boolean getServiceField(ServiceType type) {
        return (this.supportedServices >> type.ordinal() & 1) == 1;
    }

    public boolean isEmbedded() {
        return this.getServiceField(ServiceType.Embedded);
    }

    public boolean isNAS() {
        return this.getServiceField(ServiceType.NAS);
    }

    public boolean isStargate() {
        return this.getServiceField(ServiceType.Stargate);
    }

    public boolean hasUpnpIgd() {
        return this.getServiceField(ServiceType.UpnpIgd);
    }

    public String getMac() {
        return this.mac;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public void setLocalIpAddress(String localIpAddress) {
        this.localIpAddress = localIpAddress;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getBuildNo() {
        return this.buildNo;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public long getLastAlive() {
        return this.lastAlive;
    }

    public Date getConnectedDate() {
        return this.connectedDate;
    }

    public boolean isEncryptedControlConnection() {
        return this.encryptedControlConnection;
    }

    public short getUpnpPort() {
        return this.upnpPort;
    }

    public void setUpnpPort(short upnpPort) {
        this.upnpPort = upnpPort;
    }

    public boolean isUpnpOldPort() {
        return this.upnpOldPort;
    }

    public void setUpnpOldPort(boolean upnpOldPort) {
        this.upnpOldPort = upnpOldPort;
    }

    public long getUpnpLastCheck() {
        return this.upnpLastCheck;
    }

    public void setUpnpLastCheck(long upnpLastCheck) {
        this.upnpLastCheck = upnpLastCheck;
    }

    private static enum ServiceType {
        NAS,
        Gateway,
        Embedded,
        Stargate,
        UpnpIgd;

    }
}

