/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.google.gson.Gson;
import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.model.UpnpForwardingState;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.impl.SetUpForwardingException;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import com.vestiacom.gdserver.util.ExceptionsTrigger;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.upnp.UPnPApp;
import org.apache.http.entity.StringEntity;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UpnpPortForwardingServiceImpl.class, Utils.class, SetUpUpnpForwardingResult.class, Gson.class, StringEntity.class, ExceptionsTrigger.class, SetUpForwardingException.class, System.class})
public class UpnpPortForwardingServiceImplTests {
    private UpnpPortForwardingServiceImpl upnpService;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private UPnPApp upnpApp;
    private Integer staticExternalPort = 443;
    private AppServerConnector appServerConnector;
    private short portPoolBegin = (short)15800;
    private short portPoolEnd = (short)15899;
    private String portPoolOrder = "asc";
    private ThreadPoolTaskExecutor taskExecutor;

    @Before
    public void setUp() {
        this.upnpService = new UpnpPortForwardingServiceImpl();
        this.gatewayDeviceConnection = PowerMock.createMock(GatewayDeviceConnection.class);
        this.upnpService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.upnpApp = PowerMock.createMock(UPnPApp.class);
        this.upnpService.setUpnpApp(this.upnpApp);
        this.appServerConnector = PowerMock.createMock(AppServerConnector.class);
        this.upnpService.setAppServerConnector(this.appServerConnector);
        this.upnpService.setStaticExternalPort(this.staticExternalPort);
        this.upnpService.setPortPoolBegin(this.portPoolBegin);
        this.upnpService.setPortPoolEnd(this.portPoolEnd);
        this.upnpService.setPoolCheckOrder(this.portPoolOrder);
        this.taskExecutor = PowerMock.createMock(ThreadPoolTaskExecutor.class);
        this.upnpService.setTaskExecutor(this.taskExecutor);
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(System.class);
    }

    @Test
    public void testSetUpForwardingWithPort0Checking() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 0;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, this.portPoolBegin)).andReturn(true);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.Checking);
        result.setStatusCode(0);
        result.setReason("Checking...");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)errorCode);
        Assert.assertEquals(result, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithPort0CommunicationProblem() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 0;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, this.portPoolBegin)).andReturn(false);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.CommunicationProblem);
        result.setStatusCode(0);
        result.setReason("Communication Problem");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)errorCode);
        Assert.assertEquals(result, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithNon0PortChecking() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 15801;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        device.setUpnpPort(upnpPort.shortValue());
        device.setUpnpOldPort(true);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, upnpPort.shortValue())).andReturn(true);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.Checking);
        result.setStatusCode(0);
        result.setReason("Checking...");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)errorCode);
        Assert.assertEquals(result, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithNon0PortCommunicationProblem() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = 15801;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        device.setUpnpPort(upnpPort.shortValue());
        device.setUpnpOldPort(true);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, upnpPort.shortValue())).andReturn(false);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.CommunicationProblem);
        result.setStatusCode(0);
        result.setReason("Communication Problem");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)errorCode);
        Assert.assertEquals(result, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithNullPort() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = null;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, this.portPoolBegin)).andReturn(true);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(0);
        result.setState(UpnpForwardingState.Checking);
        result.setStatusCode(0);
        result.setReason("Checking...");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)errorCode);
        Assert.assertEquals(result, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingWithHasNotUpmpIgd() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = null;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(false);
        device.setUpnpPort(this.staticExternalPort.shortValue());
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(this.staticExternalPort);
        result.setState(UpnpForwardingState.Works);
        result.setStatusCode(0);
        result.setReason("Success");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        SetUpUpnpForwardingResult actual = null;
        try {
            actual = this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertNull((Object)errorCode);
        Assert.assertEquals(result, actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingDeviceNotConnected() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "testMac";
        Integer upnpPort = null;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(false);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(null);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        try {
            this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetUpUpnpForwardingResponse.ErrorCode.DEVICE_NOT_CONNECTED, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testSetUpForwardingNoDeviceId() throws Exception {
        this.upnpService.setUpnpEnabled(true);
        String mac = "";
        Integer upnpPort = null;
        EasyMock.expect(Utils.isBlank(mac)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        SetUpUpnpForwardingResponse.ErrorCode errorCode = null;
        try {
            this.upnpService.setUpForwarding(mac, upnpPort);
        }
        catch (SetUpForwardingException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)SetUpUpnpForwardingResponse.ErrorCode.NO_DEVICE_ID, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusWorks() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = true;
        short port = 15801;
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        device.setLocalIpAddress(localIp);
        EasyMock.expect(device.getUpnpPort()).andReturn(port);
        device.setUpnpPort(port);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(new Integer(port));
        result.setState(UpnpForwardingState.Works);
        result.setStatusCode(0);
        result.setReason("Success");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCodeLowerThan0() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = -1;
        boolean works = false;
        int port = 0;
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(new Integer(port));
        result.setState(UpnpForwardingState.CommunicationProblem);
        result.setStatusCode(0);
        result.setReason("Communication Problem");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0Ascending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.ASC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15800).times(2);
        device.setUpnpPort((short)15801);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15801);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, (short)15801)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0Descending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.DESC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(true);
        device.setUpnpPort(this.portPoolEnd);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolEnd);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15899).times(2);
        device.setUpnpPort((short)15898);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15898);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, (short)15898)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode718Ascending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 718;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.ASC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15800).times(2);
        device.setUpnpPort((short)15801);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15801);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, (short)15801)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode718Descending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 718;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.DESC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(true);
        device.setUpnpPort(this.portPoolEnd);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolEnd);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15899).times(2);
        device.setUpnpPort((short)15898);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15898);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, (short)15898)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode402Ascending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 402;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.ASC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(true);
        device.setUpnpPort(this.portPoolBegin);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15800).times(2);
        device.setUpnpPort((short)15801);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15801);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, (short)15801)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode402Descending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 402;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.DESC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(true);
        device.setUpnpPort(this.portPoolEnd);
        device.setUpnpOldPort(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolEnd);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15899).times(2);
        device.setUpnpPort((short)15898);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn((short)15898);
        EasyMock.expect(this.upnpApp.setupForwarding(mac, (short)15898)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0AndEndOfPoolAscending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.ASC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolEnd);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(new Integer(0));
        result.setState(UpnpForwardingState.EndOfPool);
        result.setStatusCode(0);
        result.setReason("All ports busy");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        device.setUpnpPort(this.portPoolBegin);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testForwardingStatusNotWorksAndStatusCode0AndEndOfPoolDescending() throws Exception {
        String mac = "testMac";
        String localIp = "testLocalIp";
        int statusCode = 0;
        boolean works = false;
        Whitebox.setInternalState((Object)this.upnpService, "poolCheckOrder", (Object)UpnpPortForwardingServiceImpl.Order.DESC);
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        EasyMock.expect(this.gatewayDeviceConnection.findById(mac)).andReturn(device);
        Long now = new Long(1234L);
        EasyMock.expect(System.currentTimeMillis()).andReturn(now);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.isUpnpOldPort()).andReturn(false);
        EasyMock.expect(device.getUpnpPort()).andReturn(this.portPoolBegin);
        device.setUpnpPort((short)0);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        PowerMock.expectNew(SetUpUpnpForwardingResult.class, new Object[0]).andReturn(result);
        result.setUpnpPort(new Integer(0));
        result.setState(UpnpForwardingState.EndOfPool);
        result.setStatusCode(0);
        result.setReason("All ports busy");
        String publicIp = "testPublicIp";
        EasyMock.expect(device.getPublicIpAddress()).andReturn(publicIp);
        result.setPublicIp(publicIp);
        EasyMock.expect(device.getMac()).andReturn(mac);
        this.taskExecutor.execute(EasyMock.anyObject(Runnable.class));
        device.setUpnpPort(this.portPoolEnd);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.forwardingStatus(mac, localIp, statusCode, works);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateStatusOnAppServer() throws Exception {
        String mac = "testMac";
        SetUpUpnpForwardingResult status = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        Gson gson = PowerMock.createMock(Gson.class);
        PowerMock.expectNew(Gson.class, new Object[0]).andReturn(gson);
        String jsonResult = "testJsonResult";
        EasyMock.expect(gson.toJson(status)).andReturn(jsonResult);
        Message msg = PowerMock.createMock(Message.class);
        PowerMock.expectNew(Message.class, new Object[]{Message.Type.UPNP_STATUS, mac}).andReturn(msg);
        msg.setParam(Message.Param.VALUE, jsonResult);
        this.appServerConnector.addMessage(msg);
        PowerMock.replayAll(new Object[0]);
        this.upnpService.updateStatusOnAppServer(mac, status);
        PowerMock.verifyAll();
    }
}

