/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.SystemSupport;
import com.vestiacom.gdserver.service.impl.UpdateUpnpForwardingServiceImpl;
import com.vestiacom.gdserver.service.impl.UpnpPortForwardingServiceImpl;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.upnp.UPnPApp;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UpdateUpnpForwardingServiceImpl.class, Utils.class})
public class UpdateUpnpForwardingServiceImplTests {
    private UpdateUpnpForwardingServiceImpl service;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private UPnPApp upnpApp;
    private SystemSupport systemSupport;
    private DaoFactory daoFactory;
    private ServiceFactory serviceFactory;
    private SessionDao sessionDao;

    @Before
    public void setUp() {
        this.service = new UpdateUpnpForwardingServiceImpl();
        this.gatewayDeviceConnection = PowerMock.createMock(GatewayDeviceConnection.class);
        this.service.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.upnpApp = PowerMock.createMock(UPnPApp.class);
        this.service.setUpnpApp(this.upnpApp);
        this.systemSupport = PowerMock.createMock(SystemSupport.class);
        this.service.setSystemSupport(this.systemSupport);
        this.daoFactory = PowerMock.createMock(DaoFactory.class);
        this.service.setDaoFactory(this.daoFactory);
        this.serviceFactory = PowerMock.createMock(ServiceFactory.class);
        this.service.setServiceFactory(this.serviceFactory);
    }

    @Test
    public void testUpdateForwardingStateForUpnpPort0() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        String mac = "testMac";
        short upnpPort = 0;
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(this.sessionDao.isDeviceRegisterd(mac)).andReturn(true);
        EasyMock.expect(device.getUpnpLastCheck()).andReturn(0L);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        UpnpPortForwardingServiceImpl upnpForwardingService = PowerMock.createMock(UpnpPortForwardingServiceImpl.class);
        EasyMock.expect(this.serviceFactory.getUpnpPortForwardingServiceImpl()).andReturn(upnpForwardingService);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect(upnpForwardingService.setUpForwarding(mac, 0)).andReturn(result);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateForCurrentUpnpNotWorking() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        String mac = "testMac";
        short upnpPort = 1;
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(this.sessionDao.isDeviceRegisterd(mac)).andReturn(true);
        EasyMock.expect(device.getUpnpLastCheck()).andReturn(0L);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        EasyMock.expect(this.upnpApp.forwardingWorks(mac, upnpPort)).andReturn(false);
        device.setUpnpLastCheck(now);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        UpnpPortForwardingServiceImpl upnpForwardingService = PowerMock.createMock(UpnpPortForwardingServiceImpl.class);
        EasyMock.expect(this.serviceFactory.getUpnpPortForwardingServiceImpl()).andReturn(upnpForwardingService);
        SetUpUpnpForwardingResult result = PowerMock.createMock(SetUpUpnpForwardingResult.class);
        EasyMock.expect(upnpForwardingService.setUpForwarding(mac, 1)).andReturn(result);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateForCurrentUpnpWorking() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        String mac = "testMac";
        short upnpPort = 1;
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(this.sessionDao.isDeviceRegisterd(mac)).andReturn(true);
        EasyMock.expect(device.getUpnpLastCheck()).andReturn(0L);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(device.getUpnpPort()).andReturn(upnpPort);
        EasyMock.expect(this.upnpApp.forwardingWorks(mac, upnpPort)).andReturn(true);
        device.setUpnpLastCheck(now);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateUpnpCheckRecently() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10000L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        String mac = "testMac";
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(this.sessionDao.isDeviceRegisterd(mac)).andReturn(true);
        EasyMock.expect(device.getUpnpLastCheck()).andReturn(0L);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateDeviceNotRegistered() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(true);
        String mac = "testMac";
        EasyMock.expect(device.getMac()).andReturn(mac);
        EasyMock.expect(this.sessionDao.isDeviceRegisterd(mac)).andReturn(false);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateDeviceHasNotUpnpIgd() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        ArrayList<GatewayDevice> devices = new ArrayList<GatewayDevice>();
        GatewayDevice device = PowerMock.createMock(GatewayDevice.class);
        devices.add(device);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(devices);
        EasyMock.expect(device.hasUpnpIgd()).andReturn(false);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateNullFoundDevices() {
        Integer recheckSecs = 10;
        this.sessionDao = PowerMock.createMock(SessionDao.class);
        EasyMock.expect(this.daoFactory.getSessionDao()).andReturn(this.sessionDao);
        this.service.setUpnpEnabled(true);
        this.service.setRecheckSecs(recheckSecs);
        Long now = 10001L;
        EasyMock.expect(this.systemSupport.currentTimeMillis()).andReturn(now);
        EasyMock.expect(this.gatewayDeviceConnection.getAllDevices()).andReturn(null);
        PowerMock.replayAll(new Object[0]);
        this.service.initialize();
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateForwardingStateDisabledUpnp() {
        this.service.setUpnpEnabled(false);
        PowerMock.replayAll(new Object[0]);
        this.service.updateForwardingState();
        PowerMock.verifyAll();
    }
}

