/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.service.RestProxyService;
import homemonitor.GatewayDeviceConnection;
import java.nio.ByteBuffer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class RestProxyServiceImpl
implements RestProxyService {
    AppServerConnector appServerConnector;
    private String mac;
    private short id;
    private String path;
    private GatewayDeviceConnection gatewayDeviceConnection;

    @Autowired
    @Required
    public void setAppServerConnector(AppServerConnector appServerConnector) {
        this.appServerConnector = appServerConnector;
    }

    @Override
    public void sendRequest(String mac, short id, String path, GatewayDeviceConnection gatewayDeviceConnection) {
        this.mac = mac;
        this.id = id;
        this.path = path;
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        this.sendRequestInNetworkThread();
    }

    private void sendRequestInNetworkThread() {
        new Thread(){

            @Override
            public void run() {
                String response = RestProxyServiceImpl.this.appServerConnector.getRaw(RestProxyServiceImpl.this.getRestProxyPath());
                RestProxyServiceImpl.this.sendResponse(response);
            }
        }.start();
    }

    protected void sendResponse(String response) {
        byte[] responseArray = null;
        if (response != null) {
            responseArray = response.getBytes();
        }
        ByteBuffer buffer = ByteBuffer.allocate(4 + (responseArray != null ? responseArray.length : 0));
        buffer.putShort(this.id);
        if (response != null) {
            buffer.put(responseArray);
        }
        this.gatewayDeviceConnection.sendSimple(23, this.mac, buffer.array());
    }

    protected String getRestProxyPath() {
        StringBuilder builder = new StringBuilder();
        builder.append("/internal/gd/restproxy");
        builder.append(this.path);
        builder.append(this.path.contains("?") ? "&" : "?");
        builder.append("mac=" + this.mac);
        return builder.toString();
    }
}

