/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.service.impl.HttpProxySessions;
import com.vestiacom.gdserver.util.Utils;
import java.util.Set;
import java.util.UUID;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HttpProxySessions.class, Utils.class, UUID.class})
public class HttpProxySessionsTests {
    private HttpProxySessions httpProxySessions;

    @Before
    public void setUp() {
        this.httpProxySessions = new HttpProxySessions();
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(UUID.class);
    }

    @Test
    public void testGenerate() {
        Set sessions = (Set)Whitebox.getInternalState((Object)this.httpProxySessions, "sessions");
        Assert.assertEquals(true, sessions.isEmpty());
        UUID uuid = PowerMock.createMock(UUID.class);
        EasyMock.expect(UUID.randomUUID()).andReturn(uuid);
        String sessionId = "00000000-0000-0000-0000-000000000000";
        PowerMock.replayAll(new Object[0]);
        String actual = this.httpProxySessions.generate();
        Assert.assertEquals(sessionId, actual);
        Assert.assertEquals(1L, sessions.size());
        Assert.assertEquals(sessionId, sessions.iterator().next());
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthorizeWithValidSessionId() {
        String sessionId = "testSessionId";
        Set sessions = (Set)Whitebox.getInternalState((Object)this.httpProxySessions, "sessions");
        sessions.add(sessionId);
        sessions.add("session1");
        sessions.add("session2");
        EasyMock.expect(Utils.isBlank(sessionId)).andReturn(false);
        PowerMock.replayAll(new Object[0]);
        boolean actual = this.httpProxySessions.authorize(sessionId);
        Assert.assertEquals(true, actual);
        Assert.assertEquals(2L, sessions.size());
        Assert.assertEquals(false, sessions.contains(sessionId));
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthorizeWithInvalidSessionId() {
        String sessionId = "testSessionId";
        Set sessions = (Set)Whitebox.getInternalState((Object)this.httpProxySessions, "sessions");
        sessions.add("session1");
        sessions.add("session2");
        EasyMock.expect(Utils.isBlank(sessionId)).andReturn(false);
        PowerMock.replayAll(new Object[0]);
        boolean actual = this.httpProxySessions.authorize(sessionId);
        Assert.assertEquals(false, actual);
        Assert.assertEquals(2L, sessions.size());
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthorizeWithEmptySessionId() {
        String sessionId = "";
        EasyMock.expect(Utils.isBlank(sessionId)).andReturn(true);
        PowerMock.replayAll(new Object[0]);
        boolean actual = this.httpProxySessions.authorize(sessionId);
        Assert.assertEquals(false, actual);
        PowerMock.verifyAll();
    }
}

