/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.db.dao;

import com.vestiacom.gdserver.db.dao.DataAccessException;
import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.dao.SqlError;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SqlSessionDao
implements SessionDao {
    private Logger log = Logger.getLogger(SqlSessionDao.class);
    @Autowired
    private DataSource dataSource;

    @Override
    public void store(String mac, SessionEntity session) {
        this.log.trace("start store(session=" + session + ")");
        if (this.update(mac, session) == 0) {
            this.create(mac, session);
        }
    }

    private int update(String mac, SessionEntity session) {
        int n;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            String inquiry = "update clientsession set public_ip=?, server_url=?, registered=? where mac=?";
            statement = connection.prepareStatement(inquiry);
            this.dematerializeSession(statement, session, mac);
            n = statement.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new SqlError(ex);
            }
            catch (Throwable throwable) {
                SqlUtil.close(resultSet, statement, connection);
                throw throwable;
            }
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
        return n;
    }

    private int create(String mac, SessionEntity session) {
        int n;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            String inquiry = "insert into clientsession (public_ip, server_url, registered, mac) values (?, ?, ?, ?)";
            statement = connection.prepareStatement(inquiry);
            this.dematerializeSession(statement, session, mac);
            n = statement.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new SqlError(ex);
            }
            catch (Throwable throwable) {
                SqlUtil.close(resultSet, statement, connection);
                throw throwable;
            }
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
        return n;
    }

    @Override
    public void disconnected(String mac, String serverUrl) {
    }

    @Override
    public void disconnected(String serverUrl) {
    }

    @Override
    public void registered(String mac, boolean registered) {
        this.log.trace("start registered(mac=" + mac + ", registered=" + registered + ")");
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                String inquiry = "update clientsession set registered = ? where mac = ?";
                statement = connection.prepareStatement(inquiry);
                statement.setBoolean(1, registered);
                statement.setString(2, mac);
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                throw new SqlError(ex);
            }
        }
        catch (Throwable throwable) {
            SqlUtil.close(resultSet, statement, connection);
            throw throwable;
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
    }

    private void dematerializeSession(PreparedStatement ps, SessionEntity session, String mac) throws SQLException {
        int i = 0;
        ps.setString(++i, session.getPublicIp());
        ps.setString(++i, session.getServerUrl());
        ps.setBoolean(++i, session.isRegistered());
        ps.setString(++i, mac);
    }

    @Override
    public SessionEntity get(String mac) {
        SessionEntity sessionEntity;
        this.log.trace("start get(mac=" + mac + ")");
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement("select * from clientsession where mac = ?");
            statement.setString(1, mac);
            resultSet = statement.executeQuery();
            SessionEntity session = null;
            if (resultSet.next()) {
                session = this.materializeSession(resultSet);
                if (resultSet.next()) {
                    throw new DataAccessException(DataAccessException.ErrorCode.TOO_MANY_ENTITIES_FOUND);
                }
            }
            sessionEntity = session;
        }
        catch (SQLException ex) {
            try {
                throw new SqlError(ex);
            }
            catch (Throwable throwable) {
                SqlUtil.close(resultSet, statement, connection);
                throw throwable;
            }
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
        return sessionEntity;
    }

    private SessionEntity materializeSession(ResultSet rs) throws SQLException {
        SessionEntity session = new SessionEntity();
        session.setPublicIp(rs.getString("public_ip"));
        session.setServerUrl(rs.getString("server_url"));
        session.setRegistered(rs.getBoolean("registered"));
        return session;
    }

    @Override
    public boolean isDeviceRegisterd(String mac) {
        boolean bl;
        this.log.trace("start isDeviceRegisterd(mac=" + mac + ")");
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement("select registered from clientsession where mac = ?");
            statement.setString(1, mac);
            resultSet = statement.executeQuery();
            boolean registered = false;
            if (resultSet.next()) {
                registered = resultSet.getBoolean("registered");
                if (resultSet.next()) {
                    throw new DataAccessException(DataAccessException.ErrorCode.TOO_MANY_ENTITIES_FOUND);
                }
            }
            bl = registered;
        }
        catch (SQLException ex) {
            try {
                throw new SqlError(ex);
            }
            catch (Throwable throwable) {
                SqlUtil.close(resultSet, statement, connection);
                throw throwable;
            }
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
        return bl;
    }

    @Override
    public void remove(String mac) {
        this.log.trace("start remove(mac=" + mac + ")");
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement("delete from clientsession where mac = ?");
                statement.setString(1, mac);
                statement.execute();
            }
            catch (SQLException ex) {
                throw new SqlError(ex);
            }
        }
        catch (Throwable throwable) {
            SqlUtil.close(resultSet, statement, connection);
            throw throwable;
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
    }

    @Override
    public Collection<SessionEntity> getSessions() {
        ArrayList<SessionEntity> arrayList;
        this.log.trace("start getSessions()");
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement("select * from clientsession");
            resultSet = statement.executeQuery();
            ArrayList<SessionEntity> sessions = new ArrayList<SessionEntity>();
            if (resultSet.next()) {
                sessions.add(this.materializeSession(resultSet));
            }
            arrayList = sessions;
        }
        catch (SQLException ex) {
            try {
                throw new SqlError(ex);
            }
            catch (Throwable throwable) {
                SqlUtil.close(resultSet, statement, connection);
                throw throwable;
            }
        }
        SqlUtil.close(resultSet, (Statement)statement, connection);
        return arrayList;
    }
}

