/*
 * Decompiled with CFR 0.152.
 */
package org.marre.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.marre.xml.XmlAttribute;
import org.marre.xml.XmlWriter;

public class TextXmlWriter
implements XmlWriter {
    protected Writer myWriter;
    protected Stack myTagStack;
    protected boolean myCharsAddedBetweenTags = true;

    public TextXmlWriter(Writer writer) {
        this.myWriter = writer;
    }

    public void setDoctype(String publicID) {
    }

    public void setDoctype(String name, String systemURI) {
    }

    public void setDoctype(String name, String publicID, String publicURI) {
    }

    public void addStartElement(String tag) throws IOException {
        if (!this.myCharsAddedBetweenTags) {
            this.myWriter.write("\r\n");
        }
        this.myCharsAddedBetweenTags = false;
        this.myWriter.write("<" + tag + ">");
        this.myTagStack.push(tag);
    }

    public void addStartElement(String tag, XmlAttribute[] attribs) throws IOException {
        throw new IOException("Not implemented");
    }

    public void addEmptyElement(String tag) throws IOException {
        if (!this.myCharsAddedBetweenTags) {
            this.myWriter.write("\r\n");
        }
        this.myCharsAddedBetweenTags = false;
        this.myWriter.write("<" + tag + "/>\r\n");
    }

    public void addEmptyElement(String tag, XmlAttribute[] attribs) throws IOException {
        throw new IOException("Not implemented");
    }

    public void addEndElement() throws IOException {
        String tag = (String)this.myTagStack.pop();
        this.myWriter.write("</" + tag + ">\r\n");
    }

    public void addCharacters(char[] ch, int start, int length) throws IOException {
        this.myCharsAddedBetweenTags = true;
        this.myWriter.write(ch, start, length);
    }

    public void addCharacters(String str) throws IOException {
        this.myCharsAddedBetweenTags = true;
        this.myWriter.write(str);
    }

    public void flush() throws IOException {
        this.myWriter.flush();
    }
}

