/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.wbxml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.marre.util.StringUtil;
import org.marre.wap.WspUtil;
import org.marre.wap.wbxml.WbxmlConstants;
import org.marre.xml.XmlAttribute;
import org.marre.xml.XmlWriter;

public class WbxmlWriter
implements XmlWriter {
    private Map myStringTable;
    private ByteArrayOutputStream myStringTableBuf;
    private OutputStream myOs;
    private ByteArrayOutputStream myWbxmlBody = new ByteArrayOutputStream();
    private String[] myTagTokens;
    private String[] myAttrStartTokens;
    private String[] myAttrValueTokens;
    private String myPublicID;

    public WbxmlWriter(OutputStream os, String[] theTagTokens, String[] theAttrStrartTokens, String[] theAttrValueTokens) {
        this.myStringTableBuf = new ByteArrayOutputStream();
        this.myStringTable = new HashMap();
        this.myOs = os;
        this.setTagTokens(theTagTokens);
        this.setAttrStartTokens(theAttrStrartTokens);
        this.setAttrValueTokens(theAttrValueTokens);
    }

    public WbxmlWriter(OutputStream os) {
        this(os, null, null, null);
    }

    public void flush() throws IOException {
        WspUtil.writeUint8(this.myOs, 1);
        this.writePublicIdentifier(this.myOs, this.myPublicID);
        WspUtil.writeUintvar(this.myOs, 106L);
        this.writeStringTable(this.myOs);
        this.myWbxmlBody.close();
        this.myWbxmlBody.writeTo(this.myOs);
        this.myOs.flush();
    }

    public void setDoctype(String name, String systemURI) {
        this.myPublicID = null;
    }

    public void setDoctype(String name, String publicID, String publicURI) {
        this.myPublicID = publicID;
    }

    public void setDoctype(String publicID) {
        this.myPublicID = publicID;
    }

    public void addStartElement(String tag) throws IOException {
        int tagIndex = StringUtil.findString(this.myTagTokens, tag);
        if (tagIndex >= 0) {
            this.myWbxmlBody.write(0x40 | (tagIndex += 5));
        } else {
            this.myWbxmlBody.write(68);
            this.writeStrT(this.myWbxmlBody, tag);
        }
    }

    public void addStartElement(String tag, XmlAttribute[] attribs) throws IOException {
        int tagIndex = StringUtil.findString(this.myTagTokens, tag);
        if (tagIndex >= 0) {
            this.myWbxmlBody.write(0xFFFFFFC0 | (tagIndex += 5));
        } else if (tag != null) {
            this.myWbxmlBody.write(-60);
            this.writeStrT(this.myWbxmlBody, tag);
        }
        this.writeAttributes(this.myWbxmlBody, attribs);
    }

    public void addEmptyElement(String tag) throws IOException {
        int tagIndex = StringUtil.findString(this.myTagTokens, tag);
        if (tagIndex >= 0) {
            this.myWbxmlBody.write(0 | (tagIndex += 5));
        } else if (tag != null) {
            this.myWbxmlBody.write(4);
            this.writeStrT(this.myWbxmlBody, tag);
        }
    }

    public void addEmptyElement(String tag, XmlAttribute[] attribs) throws IOException {
        int tagIndex = StringUtil.findString(this.myTagTokens, tag);
        if (tagIndex >= 0) {
            this.myWbxmlBody.write(0xFFFFFF80 | (tagIndex += 5));
        } else {
            this.myWbxmlBody.write(-124);
            this.writeStrT(this.myWbxmlBody, tag);
        }
        this.writeAttributes(this.myWbxmlBody, attribs);
    }

    public void addEndElement() throws IOException {
        this.myWbxmlBody.write(1);
    }

    public void addCharacters(char[] ch, int start, int length) throws IOException {
        this.addCharacters(new String(ch, start, length));
    }

    public void addCharacters(String str) throws IOException {
        this.myWbxmlBody.write(3);
        this.writeStrI(this.myWbxmlBody, str);
    }

    public void addOpaqueData(byte[] buff) throws IOException {
        this.addOpaqueData(buff, 0, buff.length);
    }

    public void addOpaqueData(byte[] buff, int off, int len) throws IOException {
        this.myWbxmlBody.write(-61);
        WspUtil.writeUintvar(this.myWbxmlBody, buff.length);
        this.myWbxmlBody.write(buff, off, len);
    }

    public void setTagTokens(String[] theTagTokens) {
        if (theTagTokens != null) {
            this.myTagTokens = new String[theTagTokens.length];
            System.arraycopy(theTagTokens, 0, this.myTagTokens, 0, theTagTokens.length);
        } else {
            this.myTagTokens = null;
        }
    }

    public void setAttrStartTokens(String[] theAttrStrartTokens) {
        if (theAttrStrartTokens != null) {
            this.myAttrStartTokens = new String[theAttrStrartTokens.length];
            System.arraycopy(theAttrStrartTokens, 0, this.myAttrStartTokens, 0, theAttrStrartTokens.length);
        } else {
            this.myAttrStartTokens = null;
        }
    }

    public void setAttrValueTokens(String[] theAttrValueTokens) {
        if (theAttrValueTokens != null) {
            this.myAttrValueTokens = new String[theAttrValueTokens.length];
            System.arraycopy(theAttrValueTokens, 0, this.myAttrValueTokens, 0, theAttrValueTokens.length);
        } else {
            this.myAttrValueTokens = null;
        }
    }

    private void writePublicIdentifier(OutputStream os, String publicID) throws IOException {
        if (publicID == null) {
            WspUtil.writeUintvar(os, 1L);
        } else {
            int idx = StringUtil.findString(WbxmlConstants.KNOWN_PUBLIC_DOCTYPES, publicID);
            if (idx != -1) {
                WspUtil.writeUintvar(os, idx += 2);
            } else {
                WspUtil.writeUintvar(os, 0L);
                this.writeStrT(os, publicID);
            }
        }
    }

    private void writeStrI(OutputStream theOs, String str) throws IOException {
        if (str != null) {
            theOs.write(str.getBytes("UTF-8"));
            theOs.write(0);
        }
    }

    private void writeStrT(OutputStream theOs, String str) throws IOException {
        Integer index = (Integer)this.myStringTable.get(str);
        if (index == null) {
            index = new Integer(this.myStringTableBuf.size());
            this.myStringTable.put(str, index);
            this.writeStrI(this.myStringTableBuf, str);
        }
        WspUtil.writeUintvar(theOs, index.intValue());
    }

    private void writeStringTable(OutputStream theOs) throws IOException {
        WspUtil.writeUintvar(theOs, this.myStringTableBuf.size());
        this.myStringTableBuf.writeTo(theOs);
    }

    private void writeAttributes(OutputStream os, XmlAttribute[] attribs) throws IOException {
        for (int i = 0; i < attribs.length; ++i) {
            String typeValue = attribs[i].getType() + "=" + attribs[i].getValue();
            int idx = StringUtil.findString(this.myAttrStartTokens, typeValue);
            if (idx >= 0) {
                this.myWbxmlBody.write(idx += 5);
                continue;
            }
            idx = StringUtil.findString(this.myAttrStartTokens, attribs[i].getType());
            if (idx >= 0) {
                this.myWbxmlBody.write(idx += 5);
            } else {
                this.myWbxmlBody.write(4);
                this.writeStrT(this.myWbxmlBody, attribs[i].getType());
            }
            String attrValue = attribs[i].getValue();
            if (attrValue == null || attrValue.equals("")) continue;
            idx = StringUtil.findString(this.myAttrValueTokens, attrValue);
            if (idx >= 0) {
                this.myWbxmlBody.write(idx += 133);
                continue;
            }
            this.myWbxmlBody.write(3);
            this.writeStrI(this.myWbxmlBody, attrValue);
        }
        this.myWbxmlBody.write(1);
    }
}

