/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.push;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeBodyPart;
import org.marre.sms.SmsUserData;
import org.marre.util.StringUtil;
import org.marre.wap.mms.MmsHeaderEncoder;
import org.marre.wap.push.SmsWapPushMessage;

public class SmsMmsNotificationMessage
extends SmsWapPushMessage {
    private static final int DEFAULT_TRANSACTION_ID_LENGTH = 5;
    private static final long DEFAULT_EXPIRY = 259200L;
    protected String myTransactionId;
    protected String myFrom;
    protected String mySubject;
    protected int myMessageClassId = 0;
    protected long mySize;
    protected long myExpiry;
    protected String myContentLocation;

    public SmsMmsNotificationMessage(String theContentLocation, long size) {
        this.myContentLocation = theContentLocation;
        this.myTransactionId = StringUtil.randString(5);
        this.myExpiry = 259200L;
        this.mySize = size;
    }

    protected void writeNotificationTo(OutputStream os) throws IOException {
        MmsHeaderEncoder.writeHeaderXMmsMessageType(os, 2);
        MmsHeaderEncoder.writeHeaderXMmsTransactionId(os, this.myTransactionId);
        MmsHeaderEncoder.writeHeaderXMmsMmsVersion(os, 0);
        if (this.myFrom != null && this.myFrom.length() > 0) {
            MmsHeaderEncoder.writeHeaderFrom(os, this.myFrom);
        }
        if (this.mySubject != null && this.mySubject.length() > 0) {
            MmsHeaderEncoder.writeHeaderSubject(os, this.mySubject);
        }
        MmsHeaderEncoder.writeHeaderXMmsMessageClass(os, this.myMessageClassId);
        MmsHeaderEncoder.writeHeaderXMmsMessageSize(os, this.mySize);
        MmsHeaderEncoder.writeHeaderXMmsExpiryRelative(os, this.myExpiry);
        MmsHeaderEncoder.writeHeaderContentLocation(os, this.myContentLocation);
    }

    public void setMessageClass(int messageClassId) {
        this.myMessageClassId = messageClassId;
    }

    public void setSubject(String theSubject) {
        this.mySubject = theSubject;
    }

    public void setExpiry(int i) {
        this.myExpiry = i;
    }

    public void setFrom(String string) {
        this.myFrom = string;
    }

    public void setTransactionId(String transactionId) {
        this.myTransactionId = transactionId;
    }

    public SmsUserData getUserData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        try {
            this.writeNotificationTo(baos);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.myPushMsg = new MimeBodyPart(baos.toByteArray(), "application/vnd.wap.mms-message");
        this.setXWapApplicationId("x-wap-application:mms.ua");
        return super.getUserData();
    }
}

