/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.mms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.marre.mime.MimeHeader;
import org.marre.util.StringUtil;
import org.marre.wap.WspUtil;
import org.marre.wap.mms.MmsConstants;

public final class MmsHeaderEncoder {
    private MmsHeaderEncoder() {
    }

    public static void writeHeaderContentLocation(OutputStream theOs, String theContentLocation) throws IOException {
        WspUtil.writeShortInteger(theOs, 3);
        WspUtil.writeTextString(theOs, theContentLocation);
    }

    public static void writeHeaderContentType(byte wspEncodingVersion, OutputStream theOs, String theContentType) throws IOException {
        WspUtil.writeShortInteger(theOs, 4);
        WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType);
    }

    public static void writeHeaderContentType(byte wspEncodingVersion, OutputStream theOs, MimeHeader theContentType) throws IOException {
        WspUtil.writeShortInteger(theOs, 4);
        WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType);
    }

    public static void writeEncodedStringValue(OutputStream baos, String theStringValue) throws IOException {
        WspUtil.writeTextString(baos, theStringValue);
    }

    public static void writeHeaderXMmsMessageType(OutputStream theOs, int theMessageTypeId) throws IOException {
        WspUtil.writeShortInteger(theOs, 12);
        WspUtil.writeShortInteger(theOs, theMessageTypeId);
    }

    public static void writeHeaderXMmsMessageType(OutputStream theOs, String theMessageType) throws IOException {
        int messageTypeId = StringUtil.findString(MmsConstants.X_MMS_MESSAGE_TYPE_NAMES, theMessageType.toLowerCase());
        if (messageTypeId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsMessageType(theOs, messageTypeId);
        }
    }

    public static void writeHeaderXMmsTransactionId(OutputStream theOs, String theTransactionId) throws IOException {
        WspUtil.writeShortInteger(theOs, 24);
        WspUtil.writeTextString(theOs, theTransactionId);
    }

    public static void writeHeaderXMmsMmsVersion(OutputStream theOs, int theVersionId) throws IOException {
        WspUtil.writeShortInteger(theOs, 13);
        switch (theVersionId) {
            default: 
        }
        WspUtil.writeShortInteger(theOs, 16);
    }

    public static void writeHeaderXMmsMmsVersion(OutputStream theOs, String theVersion) throws IOException {
        int versionId = StringUtil.findString(MmsConstants.X_MMS_MMS_VERSION_NAMES, theVersion.toLowerCase());
        if (versionId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsMessageType(theOs, versionId);
        }
    }

    public static void writeHeaderDate(OutputStream theOs, Date date) throws IOException {
        WspUtil.writeShortInteger(theOs, 5);
        long time = date.getTime();
        WspUtil.writeLongInteger(theOs, time);
    }

    public static void writeHeaderFrom(OutputStream theOs, String theFrom) throws IOException {
        WspUtil.writeShortInteger(theOs, 9);
        if (theFrom == null) {
            WspUtil.writeValueLength(theOs, 1L);
            WspUtil.writeShortInteger(theOs, 1);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WspUtil.writeShortInteger(baos, 0);
            MmsHeaderEncoder.writeEncodedStringValue(baos, theFrom);
            baos.close();
            WspUtil.writeValueLength(theOs, baos.size());
            theOs.write(baos.toByteArray());
        }
    }

    public static void writeHeaderSubject(OutputStream theOs, String theSubject) throws IOException {
        WspUtil.writeShortInteger(theOs, 22);
        MmsHeaderEncoder.writeEncodedStringValue(theOs, theSubject);
    }

    public static void writeHeaderTo(OutputStream theOs, String theRecipient) throws IOException {
        WspUtil.writeShortInteger(theOs, 23);
        MmsHeaderEncoder.writeEncodedStringValue(theOs, theRecipient);
    }

    public static void writeHeaderCc(OutputStream theOs, String theRecipient) throws IOException {
        WspUtil.writeShortInteger(theOs, 2);
        MmsHeaderEncoder.writeEncodedStringValue(theOs, theRecipient);
    }

    public static void writeHeaderBcc(OutputStream theOs, String theRecipient) throws IOException {
        WspUtil.writeShortInteger(theOs, 1);
        MmsHeaderEncoder.writeEncodedStringValue(theOs, theRecipient);
    }

    public static void writeHeaderXMmsReadReply(OutputStream theOs, int theReadReplyId) throws IOException {
        WspUtil.writeShortInteger(theOs, 16);
        WspUtil.writeShortInteger(theOs, theReadReplyId);
    }

    public static void writeHeaderXMmsReadReply(OutputStream theOs, String theReadReply) throws IOException {
        int readReplyId = StringUtil.findString(MmsConstants.X_MMS_READ_REPLY_NAMES, theReadReply.toLowerCase());
        if (readReplyId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsReadReply(theOs, readReplyId);
        }
    }

    public static void writeHeaderXMmsPriority(OutputStream theOs, int thePriorityId) throws IOException {
        WspUtil.writeShortInteger(theOs, 15);
        WspUtil.writeShortInteger(theOs, thePriorityId);
    }

    public static void writeHeaderXMmsPriority(OutputStream theOs, String thePriority) throws IOException {
        int priorityId = StringUtil.findString(MmsConstants.X_MMS_PRIORITY_NAMES, thePriority.toLowerCase());
        if (priorityId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsPriority(theOs, priorityId);
        }
    }

    public static void writeHeaderXMmsStatus(OutputStream theOs, int theStatusId) throws IOException {
        WspUtil.writeShortInteger(theOs, 21);
        WspUtil.writeShortInteger(theOs, theStatusId);
    }

    public static void writeHeaderXMmsStatus(OutputStream theOs, String theStatus) throws IOException {
        int statusId = StringUtil.findString(MmsConstants.X_MMS_STATUS_NAMES, theStatus.toLowerCase());
        if (statusId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsStatus(theOs, statusId);
        }
    }

    public static void writeHeaderXMmsMessageClass(OutputStream theOs, int theMessageClassId) throws IOException {
        WspUtil.writeShortInteger(theOs, 10);
        WspUtil.writeShortInteger(theOs, theMessageClassId);
    }

    public static void writeHeaderXMmsMessageClass(OutputStream theOs, String theMessageClass) throws IOException {
        int messageClassId = StringUtil.findString(MmsConstants.X_MMS_MESSAGE_CLASS_NAMES, theMessageClass.toLowerCase());
        if (messageClassId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsMessageClass(theOs, messageClassId);
        }
    }

    public static void writeHeaderXMmsMessageSize(OutputStream theOs, long messageSize) throws IOException {
        WspUtil.writeShortInteger(theOs, 14);
        WspUtil.writeLongInteger(theOs, messageSize);
    }

    public static void writeHeaderXMmsExpiryAbsolute(OutputStream theOs, long theExpiry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WspUtil.writeShortInteger(baos, 0);
        WspUtil.writeLongInteger(baos, theExpiry);
        baos.close();
        WspUtil.writeShortInteger(theOs, 8);
        WspUtil.writeValueLength(theOs, baos.size());
        theOs.write(baos.toByteArray());
    }

    public static void writeHeaderXMmsExpiryAbsolute(OutputStream theOs, Date theExpiry) throws IOException {
        MmsHeaderEncoder.writeHeaderXMmsExpiryAbsolute(theOs, theExpiry.getTime());
    }

    public static void writeHeaderXMmsExpiryRelative(OutputStream theOs, long theExpiry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WspUtil.writeShortInteger(baos, 1);
        WspUtil.writeLongInteger(baos, theExpiry);
        baos.close();
        WspUtil.writeShortInteger(theOs, 8);
        WspUtil.writeValueLength(theOs, baos.size());
        theOs.write(baos.toByteArray());
    }

    public static void writeHeaderXMmsSenderVisibility(OutputStream theOs, int theVisibilityId) throws IOException {
        WspUtil.writeShortInteger(theOs, 20);
        WspUtil.writeShortInteger(theOs, theVisibilityId);
    }

    public static void writeHeaderXMmsSenderVisibility(OutputStream theOs, String theVisibility) throws IOException {
        int visibilityId = StringUtil.findString(MmsConstants.X_MMS_SENDER_VISIBILITY_NAMES, theVisibility.toLowerCase());
        if (visibilityId != -1) {
            MmsHeaderEncoder.writeHeaderXMmsSenderVisibility(theOs, visibilityId);
        }
    }

    public static void writeApplicationHeader(OutputStream theOs, String theName, String theValue) throws IOException {
        WspUtil.writeTokenText(theOs, theName);
        WspUtil.writeTextString(theOs, theValue);
    }
}

