/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeHeaderParam;

public final class WspUtil {
    private static Map myWspHeaders;
    private static Map myWspContentTypes;
    private static Map myWspParameters;
    private static Map myWspPushAppTypes;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_11;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_12;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_13;
    private static final int[] WELL_KNOWN_HEADER_ID_WSP_14;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_11;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_12;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_13;
    private static final int[] WELL_KNOWN_PARAMETER_ID_WSP_14;
    private static final int[] PARAMETER_TYPES;

    private WspUtil() {
    }

    public static int getHeaderType(String headerName) {
        Integer headerType = (Integer)myWspHeaders.get(headerName);
        return headerType != null ? headerType : -1;
    }

    public static int getWellKnownHeaderId(byte wspEncodingVersion, int headerType) {
        int wellKnownHeaderId;
        switch (wspEncodingVersion) {
            case 17: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_11[headerType];
                break;
            }
            case 18: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_12[headerType];
                break;
            }
            case 19: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_13[headerType];
                break;
            }
            case 20: 
            case 21: {
                wellKnownHeaderId = WELL_KNOWN_HEADER_ID_WSP_14[headerType];
                break;
            }
            default: {
                wellKnownHeaderId = -1;
            }
        }
        return wellKnownHeaderId;
    }

    public static int getWellKnownContentTypeId(byte wspEncodingVersion, String contentType) {
        Integer contentTypeIdInt = (Integer)myWspContentTypes.get(contentType);
        if (contentTypeIdInt == null) {
            return -1;
        }
        int wellKnownContentTypeId = contentTypeIdInt;
        if (wspEncodingVersion >= 17 && wellKnownContentTypeId <= 45) {
            return wellKnownContentTypeId;
        }
        if (wspEncodingVersion >= 18 && wellKnownContentTypeId <= 52) {
            return wellKnownContentTypeId;
        }
        if (wspEncodingVersion >= 19 && wellKnownContentTypeId <= 54) {
            return wellKnownContentTypeId;
        }
        if (wspEncodingVersion >= 20 && wellKnownContentTypeId <= 63) {
            return wellKnownContentTypeId;
        }
        if (wspEncodingVersion >= 21 && wellKnownContentTypeId <= 75) {
            return wellKnownContentTypeId;
        }
        return -1;
    }

    public static int getParameterType(String parameterName) {
        Integer parameterType = (Integer)myWspParameters.get(parameterName);
        return parameterType != null ? parameterType : -1;
    }

    public static int getWspParameterType(int wellKnownParameterId) {
        return PARAMETER_TYPES[wellKnownParameterId];
    }

    public static int getWellKnownParameterId(byte wspEncodingVersion, int parameterType) {
        int wellKnownParameterId = -1;
        if (parameterType >= 0) {
            switch (wspEncodingVersion) {
                case 17: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_11[parameterType];
                    break;
                }
                case 18: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_12[parameterType];
                    break;
                }
                case 19: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_13[parameterType];
                    break;
                }
                case 20: 
                case 21: {
                    wellKnownParameterId = WELL_KNOWN_PARAMETER_ID_WSP_14[parameterType];
                    break;
                }
            }
        }
        return wellKnownParameterId;
    }

    public static int getWellKnownPushAppId(String pushApp) {
        Integer pushAppIdInt = (Integer)myWspPushAppTypes.get(pushApp);
        if (pushAppIdInt == null) {
            return -1;
        }
        return pushAppIdInt;
    }

    public static void writeUint8(OutputStream theOs, int theValue) throws IOException {
        theOs.write(theValue);
    }

    public static void writeUintvar(OutputStream theOs, long theValue) throws IOException {
        int nOctets = 1;
        while (theValue >> 7 * nOctets > 0L) {
            ++nOctets;
        }
        for (int i = nOctets; i > 0; --i) {
            byte octet = (byte)(theValue >> 7 * (i - 1));
            byte byteValue = (byte)(octet & 0x7F);
            if (i > 1) {
                byteValue = (byte)(byteValue | 0xFFFFFF80);
            }
            theOs.write(byteValue);
        }
    }

    public static void writeLongInteger(OutputStream theOs, long theValue) throws IOException {
        int nOctets = 0;
        while (theValue >> 8 * nOctets > 0L) {
            ++nOctets;
        }
        theOs.write((byte)nOctets);
        for (int i = nOctets; i > 0; --i) {
            byte octet = (byte)(theValue >> 8 * (i - 1));
            byte byteValue = (byte)(octet & 0xFFFFFFFF);
            theOs.write(byteValue);
        }
    }

    public static void writeInteger(OutputStream theOs, long theValue) throws IOException {
        if (theValue < 128L) {
            WspUtil.writeShortInteger(theOs, (int)theValue);
        } else {
            WspUtil.writeLongInteger(theOs, theValue);
        }
    }

    public static void writeShortInteger(OutputStream theOs, int theValue) throws IOException {
        theOs.write((byte)(theValue | 0xFFFFFF80));
    }

    public static void writeValueLength(OutputStream theOs, long theValue) throws IOException {
        if (theValue <= 30L) {
            theOs.write((int)theValue);
        } else {
            theOs.write(31);
            WspUtil.writeUintvar(theOs, theValue);
        }
    }

    public static void writeExtensionMedia(OutputStream theOs, String theStr) throws IOException {
        theOs.write(theStr.getBytes("ISO-8859-1"));
        theOs.write(0);
    }

    public static void writeTextString(OutputStream theOs, String theStr) throws IOException {
        byte[] strBytes = theStr.getBytes("ISO-8859-1");
        if ((strBytes[0] & 0x80) > 0) {
            theOs.write(127);
        }
        theOs.write(strBytes);
        theOs.write(0);
    }

    public static void writeQuotedString(OutputStream theOs, String theStr) throws IOException {
        theOs.write(34);
        theOs.write(theStr.getBytes("ISO-8859-1"));
        theOs.write(0);
    }

    public static void writeTokenText(OutputStream theOs, String theStr) throws IOException {
        theOs.write(theStr.getBytes("ISO-8859-1"));
        theOs.write(0);
    }

    public static void writeTextValue(OutputStream theOs, String theStr) throws IOException {
        WspUtil.writeQuotedString(theOs, theStr);
    }

    public static void writeContentType(byte wspEncodingVersion, OutputStream theOs, String theContentType) throws IOException {
        int wellKnownContentType = WspUtil.getWellKnownContentTypeId(wspEncodingVersion, theContentType.toLowerCase());
        if (wellKnownContentType == -1) {
            WspUtil.writeValueLength(theOs, theContentType.length() + 1);
            WspUtil.writeExtensionMedia(theOs, theContentType);
        } else {
            WspUtil.writeShortInteger(theOs, wellKnownContentType);
        }
    }

    public static void writeContentType(byte wspEncodingVersion, OutputStream theOs, MimeHeader theContentType) throws IOException {
        if (theContentType.getParamCount() == 0) {
            WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType.getValue());
        } else {
            String theContentTypeStr = theContentType.getValue();
            int wellKnownContentType = WspUtil.getWellKnownContentTypeId(wspEncodingVersion, theContentTypeStr.toLowerCase());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (wellKnownContentType == -1) {
                WspUtil.writeExtensionMedia(baos, theContentType.getValue());
            } else {
                WspUtil.writeInteger(baos, wellKnownContentType);
            }
            for (int i = 0; i < theContentType.getParamCount(); ++i) {
                MimeHeaderParam headerParam = theContentType.getParam(i);
                WspUtil.writeParameter(wspEncodingVersion, baos, headerParam.getName(), headerParam.getValue());
            }
            baos.close();
            WspUtil.writeValueLength(theOs, baos.size());
            theOs.write(baos.toByteArray());
        }
    }

    public static void writeTypedValue(byte wspEncodingVersion, OutputStream os, int wspParamType, String value) throws IOException {
        switch (wspParamType) {
            case 1: {
                os.write(0);
                break;
            }
            case 2: {
                WspUtil.writeTextValue(os, value);
                break;
            }
            case 3: {
                WspUtil.writeInteger(os, Long.parseLong(value));
                break;
            }
            case 4: {
                Long l = Long.valueOf(value);
                WspUtil.writeLongInteger(os, l);
                break;
            }
            case 5: {
                Integer i = Integer.valueOf(value);
                WspUtil.writeInteger(os, i.intValue());
                break;
            }
            case 6: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 7: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 8: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 9: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 10: {
                WspUtil.writeInteger(os, 106L);
                break;
            }
            case 11: {
                WspUtil.writeTextString(os, value);
                break;
            }
            case 12: {
                WspUtil.writeShortInteger(os, Integer.parseInt(value));
                break;
            }
            case 13: {
                WspUtil.writeContentType(wspEncodingVersion, os, value);
                break;
            }
            default: {
                WspUtil.writeTextString(os, value);
            }
        }
    }

    public static void writeParameter(byte wspEncodingVersion, OutputStream os, String name, String value) throws IOException {
        int parameterType = WspUtil.getParameterType(name);
        int wellKnownParameter = WspUtil.getWellKnownParameterId(wspEncodingVersion, parameterType);
        if (wellKnownParameter == -1) {
            WspUtil.writeTokenText(os, name);
            WspUtil.writeTextString(os, value);
        } else {
            WspUtil.writeInteger(os, wellKnownParameter);
            WspUtil.writeTypedValue(wspEncodingVersion, os, WspUtil.getWspParameterType(wellKnownParameter), value);
        }
    }

    public static String convertMultipartContentType(String ct) {
        if (ct.equalsIgnoreCase("multipart/*")) {
            return "application/vnd.wap.multipart.*";
        }
        if (ct.equalsIgnoreCase("multipart/mixed")) {
            return "application/vnd.wap.multipart.mixed";
        }
        if (ct.equalsIgnoreCase("multipart/form-data")) {
            return "application/vnd.wap.multipart.form-data";
        }
        if (ct.equalsIgnoreCase("multipart/byteranges")) {
            return "application/vnd.wap.multipart.byteranges";
        }
        if (ct.equalsIgnoreCase("multipart/alternative")) {
            return "application/vnd.wap.multipart.alternative";
        }
        if (ct.equalsIgnoreCase("multipart/related")) {
            return "application/vnd.wap.multipart.related";
        }
        return ct;
    }

    static {
        WELL_KNOWN_HEADER_ID_WSP_11 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_HEADER_ID_WSP_12 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_HEADER_ID_WSP_13 = new int[]{0, 59, 60, 3, 4, 5, 6, 7, 61, 9, 10, 11, 12, 13, 14, 15, 62, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 63, 64, 65, 66, 67, -1};
        WELL_KNOWN_HEADER_ID_WSP_14 = new int[]{0, 59, 60, 3, 4, 5, 6, 7, 71, 9, 10, 11, 12, 13, 14, 15, 62, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 69, 47, 48, 49, 50, 51, 52, 53, 54, 68, 56, 57, 58, 63, 64, 65, 66, 67, 70};
        WELL_KNOWN_PARAMETER_ID_WSP_11 = new int[]{0, 1, 2, 3, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_PARAMETER_ID_WSP_12 = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_PARAMETER_ID_WSP_13 = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, -1, -1, -1, -1, -1, -1};
        WELL_KNOWN_PARAMETER_ID_WSP_14 = new int[]{0, 1, 2, 3, 23, 24, 7, 8, 9, 25, 26, 27, 28, 14, 29, 16, 17, 18, 19, 20, 21, 22};
        PARAMETER_TYPES = new int[]{6, 10, 7, 3, -1, 9, 9, 11, 12, 13, 9, 9, 9, 9, 5, 9, 1, 12, 2, 4, 4, 4, 3, 2, 2, 2, 2, 2, 2, 2};
        myWspHeaders = new HashMap();
        myWspHeaders.put("accept", new Integer(0));
        myWspHeaders.put("accept-charset", new Integer(1));
        myWspHeaders.put("accept-encoding", new Integer(2));
        myWspHeaders.put("accept-language", new Integer(3));
        myWspHeaders.put("accept-ranges", new Integer(4));
        myWspHeaders.put("age", new Integer(5));
        myWspHeaders.put("allow", new Integer(6));
        myWspHeaders.put("authorization", new Integer(7));
        myWspHeaders.put("cache-control", new Integer(8));
        myWspHeaders.put("connection", new Integer(9));
        myWspHeaders.put("content-base", new Integer(10));
        myWspHeaders.put("content-encoding", new Integer(11));
        myWspHeaders.put("content-language", new Integer(12));
        myWspHeaders.put("content-length", new Integer(13));
        myWspHeaders.put("content-location", new Integer(14));
        myWspHeaders.put("content-md5", new Integer(15));
        myWspHeaders.put("content-range", new Integer(16));
        myWspHeaders.put("content-type", new Integer(17));
        myWspHeaders.put("date", new Integer(18));
        myWspHeaders.put("etag", new Integer(19));
        myWspHeaders.put("expires", new Integer(20));
        myWspHeaders.put("from", new Integer(21));
        myWspHeaders.put("host", new Integer(22));
        myWspHeaders.put("if-modified-since", new Integer(23));
        myWspHeaders.put("if-match", new Integer(24));
        myWspHeaders.put("if-none-match", new Integer(25));
        myWspHeaders.put("if-range", new Integer(26));
        myWspHeaders.put("if-unmodified-since", new Integer(27));
        myWspHeaders.put("location", new Integer(29));
        myWspHeaders.put("last-modified", new Integer(28));
        myWspHeaders.put("max-forwards", new Integer(30));
        myWspHeaders.put("pragma", new Integer(31));
        myWspHeaders.put("proxy-authenticate", new Integer(32));
        myWspHeaders.put("proxy-authorization", new Integer(33));
        myWspHeaders.put("public", new Integer(34));
        myWspHeaders.put("range", new Integer(35));
        myWspHeaders.put("referer", new Integer(36));
        myWspHeaders.put("retry-after", new Integer(37));
        myWspHeaders.put("server", new Integer(38));
        myWspHeaders.put("transfer-encoding", new Integer(39));
        myWspHeaders.put("upgrade", new Integer(40));
        myWspHeaders.put("user-agent", new Integer(41));
        myWspHeaders.put("vary", new Integer(42));
        myWspHeaders.put("via", new Integer(43));
        myWspHeaders.put("warning", new Integer(44));
        myWspHeaders.put("www-authenticate", new Integer(45));
        myWspHeaders.put("content-disposition", new Integer(46));
        myWspHeaders.put("accept", new Integer(0));
        myWspHeaders.put("x-wap-application-id", new Integer(47));
        myWspHeaders.put("x-wap-content-uri", new Integer(48));
        myWspHeaders.put("x-wap-initiator-uri", new Integer(49));
        myWspHeaders.put("bearer-indication", new Integer(51));
        myWspHeaders.put("accept-application", new Integer(50));
        myWspHeaders.put("push-flag", new Integer(52));
        myWspHeaders.put("profile", new Integer(53));
        myWspHeaders.put("profile-diff", new Integer(54));
        myWspHeaders.put("profile-warning", new Integer(55));
        myWspHeaders.put("expect", new Integer(56));
        myWspHeaders.put("te", new Integer(57));
        myWspHeaders.put("trailer", new Integer(58));
        myWspHeaders.put("accept-charset", new Integer(1));
        myWspHeaders.put("accept-encoding", new Integer(2));
        myWspHeaders.put("cache-control", new Integer(8));
        myWspHeaders.put("content-range", new Integer(16));
        myWspHeaders.put("x-wap-tod", new Integer(59));
        myWspHeaders.put("content-id", new Integer(60));
        myWspHeaders.put("set-cookie", new Integer(61));
        myWspHeaders.put("cookie", new Integer(62));
        myWspHeaders.put("encoding-version", new Integer(63));
        myWspHeaders.put("profile-warning", new Integer(55));
        myWspHeaders.put("content-disposition", new Integer(46));
        myWspHeaders.put("x-wap-security", new Integer(64));
        myWspHeaders.put("cache-control", new Integer(8));
        myWspContentTypes = new HashMap();
        myWspContentTypes.put("*/*", new Integer(0));
        myWspContentTypes.put("text/*", new Integer(1));
        myWspContentTypes.put("text/html", new Integer(2));
        myWspContentTypes.put("text/plain", new Integer(3));
        myWspContentTypes.put("text/x-hdml", new Integer(4));
        myWspContentTypes.put("text/x-ttml", new Integer(5));
        myWspContentTypes.put("text/x-vCalendar", new Integer(6));
        myWspContentTypes.put("text/x-vCard", new Integer(7));
        myWspContentTypes.put("text/vnd.wap.wml", new Integer(8));
        myWspContentTypes.put("text/vnd.wap.wmlscript", new Integer(9));
        myWspContentTypes.put("text/vnd.wap.wta-event", new Integer(10));
        myWspContentTypes.put("multipart/*", new Integer(11));
        myWspContentTypes.put("multipart/mixed", new Integer(12));
        myWspContentTypes.put("multipart/form-data", new Integer(13));
        myWspContentTypes.put("multipart/byteranges", new Integer(14));
        myWspContentTypes.put("multipart/alternative", new Integer(15));
        myWspContentTypes.put("application/*", new Integer(16));
        myWspContentTypes.put("application/java-vm", new Integer(17));
        myWspContentTypes.put("application/x-www-form-urlencoded", new Integer(18));
        myWspContentTypes.put("application/x-hdmlc", new Integer(19));
        myWspContentTypes.put("application/vnd.wap.wmlc", new Integer(20));
        myWspContentTypes.put("application/vnd.wap.wmlscriptc", new Integer(21));
        myWspContentTypes.put("application/vnd.wap.wta-eventc", new Integer(22));
        myWspContentTypes.put("application/vnd.wap.uaprof", new Integer(23));
        myWspContentTypes.put("application/vnd.wap.wtls-ca-certificate", new Integer(24));
        myWspContentTypes.put("application/vnd.wap.wtls-user-certificate", new Integer(25));
        myWspContentTypes.put("application/x-x509-ca-cert", new Integer(26));
        myWspContentTypes.put("application/x-x509-user-cert", new Integer(27));
        myWspContentTypes.put("image/*", new Integer(28));
        myWspContentTypes.put("image/gif", new Integer(29));
        myWspContentTypes.put("image/jpeg", new Integer(30));
        myWspContentTypes.put("image/tiff", new Integer(31));
        myWspContentTypes.put("image/png", new Integer(32));
        myWspContentTypes.put("image/vnd.wap.wbmp", new Integer(33));
        myWspContentTypes.put("application/vnd.wap.multipart.*", new Integer(34));
        myWspContentTypes.put("application/vnd.wap.multipart.mixed", new Integer(35));
        myWspContentTypes.put("application/vnd.wap.multipart.form-data", new Integer(36));
        myWspContentTypes.put("application/vnd.wap.multipart.byteranges", new Integer(37));
        myWspContentTypes.put("application/vnd.wap.multipart.alternative", new Integer(38));
        myWspContentTypes.put("application/xml", new Integer(39));
        myWspContentTypes.put("text/xml", new Integer(40));
        myWspContentTypes.put("application/vnd.wap.wbxml", new Integer(41));
        myWspContentTypes.put("application/x-x968-cross-cert", new Integer(42));
        myWspContentTypes.put("application/x-x968-ca-cert", new Integer(43));
        myWspContentTypes.put("application/x-x968-user-cert", new Integer(44));
        myWspContentTypes.put("text/vnd.wap.si", new Integer(45));
        myWspContentTypes.put("application/vnd.wap.sic", new Integer(46));
        myWspContentTypes.put("text/vnd.wap.sl", new Integer(47));
        myWspContentTypes.put("application/vnd.wap.slc", new Integer(48));
        myWspContentTypes.put("text/vnd.wap.co", new Integer(49));
        myWspContentTypes.put("application/vnd.wap.coc", new Integer(50));
        myWspContentTypes.put("application/vnd.wap.multipart.related", new Integer(51));
        myWspContentTypes.put("application/vnd.wap.sia", new Integer(52));
        myWspContentTypes.put("text/vnd.wap.connectivity-xml", new Integer(53));
        myWspContentTypes.put("application/vnd.wap.connectivity-wbxml", new Integer(54));
        myWspContentTypes.put("application/pkcs7-mime", new Integer(55));
        myWspContentTypes.put("application/vnd.wap.hashed-certificate", new Integer(56));
        myWspContentTypes.put("application/vnd.wap.signed-certificate", new Integer(57));
        myWspContentTypes.put("application/vnd.wap.cert-response", new Integer(58));
        myWspContentTypes.put("application/xhtml+xml", new Integer(59));
        myWspContentTypes.put("application/wml+xml", new Integer(60));
        myWspContentTypes.put("text/css", new Integer(61));
        myWspContentTypes.put("application/vnd.wap.mms-message", new Integer(62));
        myWspContentTypes.put("application/vnd.wap.rollover-certificate", new Integer(63));
        myWspContentTypes.put("application/vnd.wap.locc+wbxml", new Integer(64));
        myWspContentTypes.put("application/vnd.wap.loc+xml", new Integer(65));
        myWspContentTypes.put("application/vnd.syncml.dm+wbxml", new Integer(66));
        myWspContentTypes.put("application/vnd.syncml.dm+xml", new Integer(67));
        myWspContentTypes.put("application/vnd.syncml.notification", new Integer(68));
        myWspContentTypes.put("application/vnd.wap.xhtml+xml", new Integer(69));
        myWspContentTypes.put("application/vnd.wv.csp.cir", new Integer(70));
        myWspContentTypes.put("application/vnd.oma.dd+xml", new Integer(71));
        myWspContentTypes.put("application/vnd.oma.drm.message", new Integer(72));
        myWspContentTypes.put("application/vnd.oma.drm.content", new Integer(73));
        myWspContentTypes.put("application/vnd.oma.drm.rights+xml", new Integer(74));
        myWspContentTypes.put("application/vnd.oma.drm.rights+wbxml", new Integer(75));
        myWspParameters = new HashMap();
        myWspParameters.put("q", new Integer(0));
        myWspParameters.put("charset", new Integer(1));
        myWspParameters.put("level", new Integer(2));
        myWspParameters.put("type", new Integer(3));
        myWspParameters.put("name", new Integer(4));
        myWspParameters.put("filename", new Integer(5));
        myWspParameters.put("differences", new Integer(6));
        myWspParameters.put("padding", new Integer(7));
        myWspParameters.put("type", new Integer(8));
        myWspParameters.put("start", new Integer(9));
        myWspParameters.put("start-info", new Integer(10));
        myWspParameters.put("comment", new Integer(11));
        myWspParameters.put("domain", new Integer(12));
        myWspParameters.put("max-age", new Integer(13));
        myWspParameters.put("path", new Integer(14));
        myWspParameters.put("secure", new Integer(15));
        myWspParameters.put("sec", new Integer(16));
        myWspParameters.put("mac", new Integer(17));
        myWspParameters.put("creation-date", new Integer(18));
        myWspParameters.put("modification-date", new Integer(19));
        myWspParameters.put("read-date", new Integer(20));
        myWspParameters.put("size", new Integer(21));
        myWspParameters.put("name", new Integer(4));
        myWspParameters.put("filename", new Integer(5));
        myWspParameters.put("start", new Integer(9));
        myWspParameters.put("start-info", new Integer(10));
        myWspParameters.put("comment", new Integer(11));
        myWspParameters.put("domain", new Integer(12));
        myWspParameters.put("path", new Integer(14));
        myWspPushAppTypes = new HashMap();
        myWspPushAppTypes.put("x-wap-application:*", new Integer(0));
        myWspPushAppTypes.put("x-wap-application:push.sia", new Integer(1));
        myWspPushAppTypes.put("x-wap-application:wml.ua", new Integer(2));
        myWspPushAppTypes.put("x-wap-application:wta.ua", new Integer(3));
        myWspPushAppTypes.put("x-wap-application:mms.ua", new Integer(4));
        myWspPushAppTypes.put("x-wap-application:push.syncml", new Integer(5));
        myWspPushAppTypes.put("x-wap-application:loc.ua", new Integer(6));
        myWspPushAppTypes.put("x-wap-application:syncml.dm", new Integer(7));
        myWspPushAppTypes.put("x-wap-application:drm.ua", new Integer(8));
        myWspPushAppTypes.put("x-wap-application:emn.ua", new Integer(9));
        myWspPushAppTypes.put("x-wap-application:wv.ua", new Integer(10));
        myWspPushAppTypes.put("x-wap-microsoft:localcontent.ua", new Integer(32768));
        myWspPushAppTypes.put("x-wap-microsoft:imclient.ua ", new Integer(32769));
        myWspPushAppTypes.put("x-wap-docomo:imode.mail.ua ", new Integer(32770));
        myWspPushAppTypes.put("x-wap-docomo:imode.mr.ua", new Integer(32771));
        myWspPushAppTypes.put("x-wap-docomo:imode.mf.ua", new Integer(32772));
        myWspPushAppTypes.put("x-motorola:location.ua ", new Integer(32773));
        myWspPushAppTypes.put("x-motorola:now.ua", new Integer(32774));
        myWspPushAppTypes.put("x-motorola:otaprov.ua", new Integer(32775));
        myWspPushAppTypes.put("x-motorola:browser.ua", new Integer(32776));
        myWspPushAppTypes.put("x-motorola:splash.ua", new Integer(32777));
        myWspPushAppTypes.put("x-wap-nai:mvsw.command ", new Integer(32779));
        myWspPushAppTypes.put("x-wap-openwave:iota.ua", new Integer(32784));
    }
}

