/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeHeader;
import org.marre.wap.WspUtil;

public final class WspHeaderEncoder {
    private WspHeaderEncoder() {
    }

    public static void writeHeader(byte wspEncodingVersion, OutputStream theOs, MimeHeader theHeader) throws IOException {
        String headerName = theHeader.getName().toLowerCase();
        int headerType = WspUtil.getHeaderType(headerName);
        switch (headerType) {
            case 0: {
                break;
            }
            case 50: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 51: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 46: {
                break;
            }
            case 60: {
                WspHeaderEncoder.writeHeaderContentID(wspEncodingVersion, theOs, theHeader.getValue());
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                WspHeaderEncoder.writeHeaderContentLocation(wspEncodingVersion, theOs, theHeader.getValue());
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                WspHeaderEncoder.writeHeaderContentType(wspEncodingVersion, theOs, theHeader);
                break;
            }
            case 62: {
                break;
            }
            case 18: {
                break;
            }
            case 63: {
                break;
            }
            case 19: {
                break;
            }
            case 56: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 24: {
                break;
            }
            case 23: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 53: {
                break;
            }
            case 54: {
                break;
            }
            case 55: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 52: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 61: {
                break;
            }
            case 57: {
                break;
            }
            case 58: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 47: {
                WspHeaderEncoder.writeHeaderXWapApplicationId(wspEncodingVersion, theOs, theHeader.getValue());
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                break;
            }
            case 64: {
                break;
            }
            case 59: {
                break;
            }
            default: {
                WspHeaderEncoder.writeCustomHeader(theOs, theHeader.getName(), theHeader.getValue());
            }
        }
    }

    public static void writeCustomHeader(OutputStream theOs, String name, String value) throws IOException {
        WspUtil.writeTokenText(theOs, name);
        WspUtil.writeTextString(theOs, value);
    }

    public static void writeHeaderContentID(byte wspEncodingVersion, OutputStream theOs, String theContentId) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 60);
        if (headerId != -1) {
            WspUtil.writeShortInteger(theOs, headerId);
            WspUtil.writeQuotedString(theOs, theContentId);
        } else {
            WspHeaderEncoder.writeCustomHeader(theOs, "Content-ID", theContentId);
        }
    }

    public static void writeHeaderContentLocation(byte wspEncodingVersion, OutputStream theOs, String theContentLocation) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 14);
        WspUtil.writeShortInteger(theOs, headerId);
        WspUtil.writeTextString(theOs, theContentLocation);
    }

    public static void writeHeaderContentType(byte wspEncodingVersion, OutputStream theOs, String theContentType) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 17);
        WspUtil.writeShortInteger(theOs, headerId);
        WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType);
    }

    public static void writeHeaderContentType(byte wspEncodingVersion, OutputStream theOs, MimeHeader theContentType) throws IOException {
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 17);
        WspUtil.writeShortInteger(theOs, headerId);
        WspUtil.writeContentType(wspEncodingVersion, theOs, theContentType);
    }

    public static void writeHeaderXWapApplicationId(byte wspEncodingVersion, OutputStream theOs, String theAppId) throws IOException {
        int wellKnownAppId = WspUtil.getWellKnownPushAppId(theAppId.toLowerCase());
        int headerId = WspUtil.getWellKnownHeaderId(wspEncodingVersion, 47);
        if (headerId != -1) {
            WspUtil.writeShortInteger(theOs, headerId);
            if (wellKnownAppId == -1) {
                WspUtil.writeTextString(theOs, theAppId);
            } else {
                WspUtil.writeInteger(theOs, wellKnownAppId);
            }
        } else {
            WspHeaderEncoder.writeCustomHeader(theOs, "X-Wap-Application-Id", theAppId);
        }
    }
}

