/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeMultipart;
import org.marre.mime.encoder.MimeEncoder;
import org.marre.mime.encoder.TextMimeEncoder;
import org.marre.wap.WspHeaderEncoder;
import org.marre.wap.WspUtil;

public class WapMimeEncoder
implements MimeEncoder {
    private TextMimeEncoder myTextMimeEncoder = new TextMimeEncoder();
    private byte myWspEncodingVersion;

    public WapMimeEncoder() {
        this(18);
    }

    public WapMimeEncoder(byte wspEncodingVersion) {
        this.myWspEncodingVersion = wspEncodingVersion;
    }

    public void writeContentType(OutputStream theOs, MimeBodyPart theMsg) throws IOException {
        if (theMsg instanceof MimeMultipart) {
            String ct = theMsg.getContentType().getValue();
            String newCt = WspUtil.convertMultipartContentType(ct);
            theMsg.getContentType().setValue(newCt);
        }
        WspUtil.writeContentType(this.myWspEncodingVersion, theOs, theMsg.getContentType());
    }

    public void writeHeaders(OutputStream theOs, MimeBodyPart theMsg) throws IOException {
        for (int i = 0; i < theMsg.getHeaderCount(); ++i) {
            MimeHeader header = theMsg.getHeader(i);
            WspHeaderEncoder.writeHeader(this.myWspEncodingVersion, theOs, header);
        }
    }

    public void writeBody(OutputStream theOs, MimeBodyPart theMsg) throws IOException {
        if (theMsg instanceof MimeMultipart) {
            String ct = theMsg.getContentType().getValue();
            String newCt = WspUtil.convertMultipartContentType(ct);
            theMsg.getContentType().setValue(newCt);
            if (newCt.startsWith("application/vnd.wap.multipart.")) {
                this.writeMultipart(theOs, (MimeMultipart)theMsg);
            }
        } else {
            theOs.write(theMsg.getBody());
        }
    }

    private void writeMultipart(OutputStream theOs, MimeMultipart theMultipart) throws IOException {
        WspUtil.writeUintvar(theOs, theMultipart.getBodyPartCount());
        for (int i = 0; i < theMultipart.getBodyPartCount(); ++i) {
            MimeBodyPart part = theMultipart.getBodyPart(i);
            ByteArrayOutputStream headers = new ByteArrayOutputStream();
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            this.writeContentType(headers, part);
            this.writeHeaders(headers, part);
            headers.close();
            this.writeBody(content, part);
            content.close();
            WspUtil.writeUintvar(theOs, headers.size());
            WspUtil.writeUintvar(theOs, content.size());
            theOs.write(headers.toByteArray());
            theOs.write(content.toByteArray());
        }
    }
}

