/*
 * Decompiled with CFR 0.152.
 */
package org.marre.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BitArrayOutputStream
extends ByteArrayOutputStream {
    private int myBitOffset;
    private int myBuffer;

    public BitArrayOutputStream(int size) {
        super(size);
        this.resetBitCounter();
    }

    public synchronized byte[] toByteArray() {
        this.flushByte();
        return super.toByteArray();
    }

    private synchronized void resetBitCounter() {
        this.myBitOffset = 0;
        this.myBuffer = 0;
    }

    public synchronized void reset() {
        super.reset();
        this.resetBitCounter();
    }

    public synchronized void flushByte() {
        if (this.myBitOffset > 0) {
            super.write(this.myBuffer);
            this.resetBitCounter();
        }
    }

    public synchronized void writeBits(byte[] data, int nBits) {
        int bitsLeft = nBits;
        int i = 0;
        while (bitsLeft > 0) {
            this.writeBits(data[i], Math.min(bitsLeft, 8));
            bitsLeft -= 8;
            ++i;
        }
    }

    public synchronized void writeBits(int data, int nBits) {
        int dataLeft = data;
        for (int bitsLeft = nBits; bitsLeft > 0; --bitsLeft) {
            this.writeBit(dataLeft & 1);
            dataLeft >>= 1;
        }
    }

    public synchronized void writeBit(int bit) {
        this.myBuffer |= (bit & 1) << this.myBitOffset;
        ++this.myBitOffset;
        if (this.myBitOffset == 8) {
            this.flushByte();
        }
    }

    public synchronized void write(int data) {
        this.writeBits(data, 8);
    }

    public synchronized void write(byte[] data) {
        this.writeBits(data, 8 * data.length);
    }

    public synchronized void write(byte[] data, int off, int len) {
        throw new RuntimeException("Not supported yet");
    }

    public synchronized void close() throws IOException {
        this.flushByte();
        super.close();
    }
}

